/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.local;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.events.EventBus;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.EventBusOptions;
import org.openqa.selenium.grid.sessionqueue.GetNewSessionResponse;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueue;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueuer;
import org.openqa.selenium.grid.sessionqueue.SessionRequest;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueueOptions;
import org.openqa.selenium.grid.sessionqueue.local.LocalNewSessionQueue;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.AttributeKey;
import org.openqa.selenium.remote.tracing.EventAttribute;
import org.openqa.selenium.remote.tracing.EventAttributeValue;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

public class LocalNewSessionQueuer
extends NewSessionQueuer {
    public final NewSessionQueue sessionRequests;
    private final EventBus bus;
    private final GetNewSessionResponse getNewSessionResponse;

    public LocalNewSessionQueuer(Tracer tracer, EventBus bus, NewSessionQueue sessionRequests, Secret registrationSecret) {
        super(tracer, registrationSecret);
        this.bus = Require.nonNull("Event bus", bus);
        this.sessionRequests = Require.nonNull("New Session Request Queue", sessionRequests);
        this.getNewSessionResponse = new GetNewSessionResponse(bus, sessionRequests);
    }

    public static NewSessionQueuer create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        EventBus bus = new EventBusOptions(config).getEventBus();
        Duration retryInterval = new NewSessionQueueOptions(config).getSessionRequestRetryInterval();
        Duration requestTimeout = new NewSessionQueueOptions(config).getSessionRequestTimeout();
        LocalNewSessionQueue sessionRequests = new LocalNewSessionQueue(tracer, bus, retryInterval, requestTimeout);
        SecretOptions secretOptions = new SecretOptions(config);
        Secret registrationSecret = secretOptions.getRegistrationSecret();
        return new LocalNewSessionQueuer(tracer, bus, sessionRequests, registrationSecret);
    }

    @Override
    public HttpResponse addToQueue(SessionRequest request) {
        this.validateSessionRequest(request);
        return this.getNewSessionResponse.add(request);
    }

    @Override
    public boolean retryAddToQueue(SessionRequest request) {
        return this.sessionRequests.offerFirst(request);
    }

    @Override
    public Optional<SessionRequest> remove(RequestId id) {
        return this.sessionRequests.remove(id);
    }

    @Override
    public int clearQueue() {
        return this.sessionRequests.clear();
    }

    @Override
    public List<Set<Capabilities>> getQueueContents() {
        return this.sessionRequests.getQueuedRequests();
    }

    @Override
    public boolean isReady() {
        return this.bus.isReady();
    }

    private void validateSessionRequest(SessionRequest request) {
        try (Span span = this.tracer.getCurrentContext().createSpan("newsession_queuer.validate");){
            HashMap<String, EventAttributeValue> attributeMap = new HashMap<String, EventAttributeValue>();
            if (request.getDesiredCapabilities().isEmpty()) {
                SessionNotCreatedException exception = new SessionNotCreatedException("No capabilities found");
                Tags.EXCEPTION.accept(attributeMap, exception);
                attributeMap.put(AttributeKey.EXCEPTION_MESSAGE.getKey(), EventAttribute.setValue(exception.getMessage()));
                span.addEvent(AttributeKey.EXCEPTION_EVENT.getKey(), attributeMap);
                throw exception;
            }
        }
    }
}

