/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionqueue.remote;

import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.grid.config.Config;
import org.openqa.selenium.grid.data.RequestId;
import org.openqa.selenium.grid.log.LoggingOptions;
import org.openqa.selenium.grid.security.AddSecretFilter;
import org.openqa.selenium.grid.security.Secret;
import org.openqa.selenium.grid.security.SecretOptions;
import org.openqa.selenium.grid.server.NetworkOptions;
import org.openqa.selenium.grid.sessionqueue.NewSessionQueuer;
import org.openqa.selenium.grid.sessionqueue.SessionRequest;
import org.openqa.selenium.grid.sessionqueue.config.NewSessionQueuerOptions;
import org.openqa.selenium.grid.web.Values;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.TypeToken;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.Filter;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Tracer;

public class RemoteNewSessionQueuer
extends NewSessionQueuer {
    private static final Type QUEUE_CONTENTS_TYPE = new TypeToken<List<Set<Capabilities>>>(){}.getType();
    private static final Json JSON = new Json();
    private final HttpClient client;
    private final Filter addSecret;

    public RemoteNewSessionQueuer(Tracer tracer, HttpClient client, Secret registrationSecret) {
        super(tracer, registrationSecret);
        this.client = Require.nonNull("HTTP client", client);
        Require.nonNull("Registration secret", registrationSecret);
        this.addSecret = new AddSecretFilter(registrationSecret);
    }

    public static NewSessionQueuer create(Config config) {
        Tracer tracer = new LoggingOptions(config).getTracer();
        URI uri = new NewSessionQueuerOptions(config).getSessionQueuerUri();
        HttpClient.Factory clientFactory = new NetworkOptions(config).getHttpClientFactory(tracer);
        SecretOptions secretOptions = new SecretOptions(config);
        Secret registrationSecret = secretOptions.getRegistrationSecret();
        try {
            return new RemoteNewSessionQueuer(tracer, clientFactory.createClient(uri.toURL()), registrationSecret);
        }
        catch (MalformedURLException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public HttpResponse addToQueue(SessionRequest request) {
        HttpRequest upstream = new HttpRequest(HttpMethod.POST, "/se/grid/newsessionqueuer/session");
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), upstream);
        upstream.setContent((Supplier)Contents.asJson(request));
        return this.client.execute(upstream);
    }

    @Override
    public boolean retryAddToQueue(SessionRequest request) {
        Require.nonNull("Session request", request);
        HttpRequest upstream = new HttpRequest(HttpMethod.POST, "/se/grid/newsessionqueuer/session/retry/" + request.getRequestId());
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), upstream);
        upstream.setContent((Supplier)Contents.asJson(request));
        HttpResponse response = this.client.with(this.addSecret).execute(upstream);
        return (Boolean)Values.get(response, Boolean.class);
    }

    @Override
    public Optional<SessionRequest> remove(RequestId reqId) {
        HttpRequest upstream = new HttpRequest(HttpMethod.GET, "/se/grid/newsessionqueuer/session/" + reqId.toString());
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), upstream);
        HttpResponse response = this.client.with(this.addSecret).execute(upstream);
        if (response.isSuccessful()) {
            String rawValue = Contents.string(response);
            if (rawValue == null || rawValue.trim().isEmpty()) {
                return Optional.empty();
            }
            return Optional.of((SessionRequest)JSON.toType(rawValue, (Type)((Object)SessionRequest.class)));
        }
        return Optional.empty();
    }

    @Override
    public int clearQueue() {
        HttpRequest upstream = new HttpRequest(HttpMethod.DELETE, "/se/grid/newsessionqueuer/queue");
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), upstream);
        HttpResponse response = this.client.with(this.addSecret).execute(upstream);
        return (Integer)Values.get(response, Integer.class);
    }

    @Override
    public List<Set<Capabilities>> getQueueContents() {
        HttpRequest upstream = new HttpRequest(HttpMethod.GET, "/se/grid/newsessionqueuer/queue");
        HttpTracing.inject(this.tracer, this.tracer.getCurrentContext(), upstream);
        HttpResponse response = this.client.execute(upstream);
        return (List)Values.get(response, QUEUE_CONTENTS_TYPE);
    }

    @Override
    public boolean isReady() {
        try {
            return this.client.execute(new HttpRequest(HttpMethod.GET, "/readyz")).isSuccessful();
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

