/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.openqa.selenium.Beta;
import org.openqa.selenium.ElementClickInterceptedException;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.ElementNotSelectableException;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.ImeActivationFailedException;
import org.openqa.selenium.ImeNotAvailableException;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.InvalidCookieDomainException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchCookieException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NoSuchSessionException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.ScriptTimeoutException;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.UnableToSetCookieException;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.interactions.InvalidCoordinatesException;
import org.openqa.selenium.interactions.MoveTargetOutOfBoundsException;
import org.openqa.selenium.remote.ScreenshotException;

public class ErrorCodes {
    @Beta
    public static final String SUCCESS_STRING = "success";
    public static final int SUCCESS = 0;
    public static final int NO_SUCH_SESSION = 6;
    public static final int NO_SUCH_ELEMENT = 7;
    public static final int NO_SUCH_FRAME = 8;
    public static final int UNKNOWN_COMMAND = 9;
    public static final int STALE_ELEMENT_REFERENCE = 10;
    public static final int ELEMENT_NOT_VISIBLE = 11;
    public static final int INVALID_ELEMENT_STATE = 12;
    public static final int UNHANDLED_ERROR = 13;
    public static final int ELEMENT_NOT_SELECTABLE = 15;
    public static final int JAVASCRIPT_ERROR = 17;
    public static final int XPATH_LOOKUP_ERROR = 19;
    public static final int TIMEOUT = 21;
    public static final int NO_SUCH_WINDOW = 23;
    public static final int INVALID_COOKIE_DOMAIN = 24;
    public static final int UNABLE_TO_SET_COOKIE = 25;
    public static final int UNEXPECTED_ALERT_PRESENT = 26;
    public static final int NO_ALERT_PRESENT = 27;
    public static final int ASYNC_SCRIPT_TIMEOUT = 28;
    public static final int INVALID_ELEMENT_COORDINATES = 29;
    public static final int IME_NOT_AVAILABLE = 30;
    public static final int IME_ENGINE_ACTIVATION_FAILED = 31;
    public static final int INVALID_SELECTOR_ERROR = 32;
    public static final int SESSION_NOT_CREATED = 33;
    public static final int MOVE_TARGET_OUT_OF_BOUNDS = 34;
    public static final int INVALID_XPATH_SELECTOR = 51;
    public static final int INVALID_XPATH_SELECTOR_RETURN_TYPER = 52;
    public static final int ELEMENT_NOT_INTERACTABLE = 60;
    public static final int INVALID_ARGUMENT = 61;
    public static final int NO_SUCH_COOKIE = 62;
    public static final int UNABLE_TO_CAPTURE_SCREEN = 63;
    public static final int ELEMENT_CLICK_INTERCEPTED = 64;
    public static final int METHOD_NOT_ALLOWED = 405;
    private static final Logger log = Logger.getLogger(ErrorCodes.class.getName());
    private static final ImmutableSet<KnownError> KNOWN_ERRORS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(new KnownError(28, "script timeout", 500, ScriptTimeoutException.class, true, true))).add(new KnownError(64, "element click intercepted", 400, ElementClickInterceptedException.class, true, true))).add(new KnownError(15, "element not selectable", 400, ElementNotSelectableException.class, true, true))).add(new KnownError(60, "element not interactable", 400, ElementNotInteractableException.class, true, true))).add(new KnownError(11, "element not visible", 400, ElementNotVisibleException.class, true, true))).add(new KnownError(31, "unsupported operation", 500, ImeActivationFailedException.class, true, false))).add(new KnownError(30, "unsupported operation", 500, ImeNotAvailableException.class, true, false))).add(new KnownError(61, "invalid argument", 400, InvalidArgumentException.class, true, true))).add(new KnownError(24, "invalid cookie domain", 400, InvalidCookieDomainException.class, true, true))).add(new KnownError(29, "invalid element coordinates", 400, InvalidCoordinatesException.class, true, true))).add(new KnownError(12, "invalid element state", 400, InvalidElementStateException.class, true, true))).add(new KnownError(32, "invalid selector", 400, InvalidSelectorException.class, true, true))).add(new KnownError(51, "invalid selector", 400, InvalidSelectorException.class, false, false))).add(new KnownError(52, "invalid selector", 400, InvalidSelectorException.class, false, true))).add(new KnownError(17, "javascript error", 500, JavascriptException.class, true, true))).add(new KnownError(405, "unknown method", 405, UnsupportedCommandException.class, false, true))).add(new KnownError(405, "unsupported operation", 500, UnsupportedCommandException.class, false, true))).add(new KnownError(34, "move target out of bounds", 500, MoveTargetOutOfBoundsException.class, true, true))).add(new KnownError(27, "no such alert", 404, NoAlertPresentException.class, true, true))).add(new KnownError(62, "no such cookie", 404, NoSuchCookieException.class, true, true))).add(new KnownError(7, "no such element", 404, NoSuchElementException.class, true, true))).add(new KnownError(8, "no such frame", 404, NoSuchFrameException.class, true, true))).add(new KnownError(6, "invalid session id", 404, NoSuchSessionException.class, true, true))).add(new KnownError(23, "no such window", 404, NoSuchWindowException.class, true, true))).add(new KnownError(33, "session not created", 500, SessionNotCreatedException.class, true, true))).add(new KnownError(10, "stale element reference", 404, StaleElementReferenceException.class, true, true))).add(new KnownError(21, "timeout", 500, TimeoutException.class, true, true))).add(new KnownError(19, "invalid selector", 400, InvalidSelectorException.class, false, false))).add(new KnownError(63, "unable to capture screen", 500, ScreenshotException.class, true, true))).add(new KnownError(25, "unable to set cookie", 500, UnableToSetCookieException.class, true, true))).add(new KnownError(26, "unexpected alert open", 500, UnhandledAlertException.class, true, true))).add(new KnownError(13, "unknown error", 500, WebDriverException.class, true, true))).add(new KnownError(9, "unknown command", 404, UnsupportedCommandException.class, true, true))).build();

    public String toState(Integer status) {
        if (status == null) {
            return this.toState(13);
        }
        if (0 == status) {
            return SUCCESS_STRING;
        }
        Set possibleMatches = KNOWN_ERRORS.stream().filter(knownError -> knownError.getJsonCode() == status.intValue()).filter(KnownError::isCanonicalForW3C).map(KnownError::getW3cCode).collect(Collectors.toSet());
        return Iterables.getOnlyElement(possibleMatches, "unhandled error");
    }

    public int toStatus(String webdriverState, Optional<Integer> httpStatus) {
        if (SUCCESS_STRING.equals(webdriverState)) {
            return 0;
        }
        List possibleMatches = KNOWN_ERRORS.stream().filter(knownError -> knownError.getW3cCode().equals(webdriverState)).filter(KnownError::isCanonicalForW3C).sorted(Comparator.comparingInt(KnownError::getJsonCode)).collect(Collectors.toList());
        if (possibleMatches.isEmpty()) {
            return 13;
        }
        KnownError error = (KnownError)possibleMatches.get(0);
        if (httpStatus.isPresent() && httpStatus.get().intValue() != error.getW3cHttpStatus()) {
            log.info(String.format("HTTP Status: '%d' -> incorrect JSON status mapping for '%s' (%d expected)", httpStatus.get(), webdriverState, error.getW3cHttpStatus()));
        }
        return error.getJsonCode();
    }

    public int getHttpStatusCode(Throwable throwable) {
        return KNOWN_ERRORS.stream().filter(error -> error.getException().isAssignableFrom(throwable.getClass())).filter(KnownError::isCanonicalForW3C).map(KnownError::getW3cHttpStatus).findAny().orElse(500);
    }

    public Class<? extends WebDriverException> getExceptionType(int statusCode) {
        if (0 == statusCode) {
            return null;
        }
        Set allPossibleExceptions = KNOWN_ERRORS.stream().filter(knownError -> knownError.getJsonCode() == statusCode).map(KnownError::getException).collect(Collectors.toSet());
        return Iterables.getOnlyElement(allPossibleExceptions, WebDriverException.class);
    }

    public Class<? extends WebDriverException> getExceptionType(String webdriverState) {
        Set possibleMatches = KNOWN_ERRORS.stream().filter(knownError -> knownError.getW3cCode().equals(webdriverState)).filter(KnownError::isCanonicalForW3C).map(KnownError::getException).collect(Collectors.toSet());
        return Iterables.getOnlyElement(possibleMatches, WebDriverException.class);
    }

    public int toStatusCode(Throwable e) {
        if (e == null) {
            return 0;
        }
        Set possibleMatches = KNOWN_ERRORS.stream().filter(knownError -> knownError.getException().equals(e.getClass())).filter(knownError -> ((KnownError)knownError).isCanonicalJsonCodeForException).map(KnownError::getJsonCode).collect(Collectors.toSet());
        return Iterables.getOnlyElement(possibleMatches, 13);
    }

    public boolean isMappableError(Throwable rootCause) {
        if (rootCause == null) {
            return false;
        }
        Set possibleMatches = KNOWN_ERRORS.stream().filter(knownError -> knownError.getException().equals(rootCause.getClass())).collect(Collectors.toSet());
        return !possibleMatches.isEmpty();
    }

    static {
        HashMap<Object, Set> matched = new HashMap<Object, Set>();
        for (KnownError knownError : KNOWN_ERRORS) {
            matched.computeIfAbsent(knownError, key -> new HashSet()).add(knownError);
        }
        for (Set errors : matched.values()) {
            if (errors.size() == 1) continue;
            throw new RuntimeException("Duplicate canonical exceptions: " + errors);
        }
    }

    private static class KnownError {
        private final int jsonCode;
        private final String w3cCode;
        private final int w3cHttpStatus;
        private final Class<? extends WebDriverException> exception;
        private final boolean isCanonicalJsonCodeForException;
        private final boolean isCanonicalForW3C;

        public KnownError(int jsonCode, String w3cCode, int w3cHttpStatus, Class<? extends WebDriverException> exception, boolean isCanonicalJsonCodeForException, boolean isCanonicalForW3C) {
            this.jsonCode = jsonCode;
            this.w3cCode = w3cCode;
            this.w3cHttpStatus = w3cHttpStatus;
            this.exception = exception;
            this.isCanonicalJsonCodeForException = isCanonicalJsonCodeForException;
            this.isCanonicalForW3C = isCanonicalForW3C;
        }

        public int getJsonCode() {
            return this.jsonCode;
        }

        public String getW3cCode() {
            return this.w3cCode;
        }

        public int getW3cHttpStatus() {
            return this.w3cHttpStatus;
        }

        public Class<? extends WebDriverException> getException() {
            return this.exception;
        }

        public boolean isCanonicalForW3C() {
            return this.isCanonicalForW3C;
        }
    }
}

