/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing.opentelemetry;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.OpenTelemetrySdkAutoConfiguration;
import java.util.logging.Logger;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.tracing.Propagator;
import org.openqa.selenium.remote.tracing.TraceContext;
import org.openqa.selenium.remote.tracing.Tracer;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryContext;
import org.openqa.selenium.remote.tracing.opentelemetry.OpenTelemetryPropagator;

public class OpenTelemetryTracer
implements Tracer {
    private static final Logger LOG = Logger.getLogger(OpenTelemetryTracer.class.getName());
    private static volatile OpenTelemetryTracer singleton;
    private final io.opentelemetry.api.trace.Tracer tracer;
    private final OpenTelemetryPropagator telemetryPropagator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OpenTelemetryTracer getInstance() {
        OpenTelemetryTracer localTracer = singleton;
        if (localTracer != null) return localTracer;
        Class<OpenTelemetryTracer> clazz = OpenTelemetryTracer.class;
        synchronized (OpenTelemetryTracer.class) {
            localTracer = singleton;
            if (localTracer != null) return localTracer;
            singleton = localTracer = OpenTelemetryTracer.createTracer();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localTracer;
        }
    }

    private static OpenTelemetryTracer createTracer() {
        LOG.info("Using OpenTelemetry for tracing");
        System.setProperty("otel.metrics.exporter", "none");
        String exporter = System.getProperty("otel.traces.exporter");
        if (exporter == null) {
            System.setProperty("otel.traces.exporter", "none");
        }
        OpenTelemetrySdk autoConfiguredSdk = OpenTelemetrySdkAutoConfiguration.initialize();
        return new OpenTelemetryTracer(autoConfiguredSdk.getTracer("default"), autoConfiguredSdk.getPropagators().getTextMapPropagator());
    }

    public OpenTelemetryTracer(io.opentelemetry.api.trace.Tracer tracer, TextMapPropagator propagator) {
        this.tracer = Require.nonNull("Tracer", tracer);
        this.telemetryPropagator = new OpenTelemetryPropagator(tracer, Require.nonNull("Formatter", propagator));
    }

    @Override
    public TraceContext getCurrentContext() {
        return new OpenTelemetryContext(this.tracer, Context.current());
    }

    @Override
    public Propagator getPropagator() {
        return this.telemetryPropagator;
    }
}

