/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.tracing.opentelemetry;

import com.google.auto.service.AutoService;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.autoconfigure.spi.SdkTracerProviderConfigurer;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonOutput;

@AutoService(value={SdkTracerProviderConfigurer.class})
public class SeleniumSpanExporter
implements SdkTracerProviderConfigurer {
    private static final Logger LOG = Logger.getLogger(SeleniumSpanExporter.class.getName());

    @Override
    public void configure(SdkTracerProviderBuilder tracerProvider) {
        tracerProvider.addSpanProcessor(SimpleSpanProcessor.create(new SpanExporter(){

            @Override
            public CompletableResultCode export(Collection<SpanData> spans) {
                spans.forEach(span -> {
                    LOG.fine(String.valueOf(span));
                    String traceId = span.getTraceId();
                    String spanId = span.getSpanId();
                    StatusData status = span.getStatus();
                    List<EventData> eventList = span.getEvents();
                    eventList.forEach(event -> {
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("eventTime", event.getEpochNanos());
                        map.put("traceId", traceId);
                        map.put("spanId", spanId);
                        map.put("spanKind", span.getKind().toString());
                        map.put("eventName", event.getName());
                        Attributes attributes = event.getAttributes();
                        map.put("attributes", attributes.asMap());
                        String jsonString = SeleniumSpanExporter.getJsonString(map);
                        if (status.getStatusCode() == StatusCode.ERROR) {
                            LOG.log(Level.WARNING, jsonString);
                        } else {
                            LOG.log(Level.FINE, jsonString);
                        }
                    });
                });
                return CompletableResultCode.ofSuccess();
            }

            @Override
            public CompletableResultCode flush() {
                return CompletableResultCode.ofSuccess();
            }

            @Override
            public CompletableResultCode shutdown() {
                return CompletableResultCode.ofSuccess();
            }
        }));
    }

    private static String getJsonString(Map<String, Object> map) {
        StringBuilder text = new StringBuilder();
        try (JsonOutput json = new Json().newOutput(text).setPrettyPrint(false);){
            json.write(map);
            text.append('\n');
        }
        return text.toString();
    }
}

