/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.devtools;

import java.io.Closeable;
import java.util.function.Supplier;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.devtools.DevTools;
import org.openqa.selenium.devtools.HasDevTools;
import org.openqa.selenium.devtools.idealized.Network;
import org.openqa.selenium.devtools.idealized.OpaqueKey;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.http.Route;

public class NetworkInterceptor
implements Closeable {
    public static final HttpResponse PROCEED_WITH_REQUEST = (HttpResponse)((HttpResponse)new HttpResponse().addHeader("Selenium-Interceptor", "Continue")).setContent((Supplier)Contents.utf8String("Original request should proceed"));
    private final OpaqueKey key;
    private final Network<?, ?> network;

    public NetworkInterceptor(WebDriver driver, Route route) {
        if (!(driver instanceof HasDevTools)) {
            throw new IllegalArgumentException("WebDriver instance must implement HasDevTools");
        }
        Require.nonNull("Route", route);
        DevTools devTools = ((HasDevTools)((Object)driver)).getDevTools();
        devTools.createSessionIfThereIsNotOne();
        this.network = devTools.getDomains().network();
        this.key = this.network.addRequestHandler(route);
    }

    @Override
    public void close() {
        this.network.removeRequestHandler(this.key);
    }
}

