﻿using System;
namespace CBGModules
{
    /// <summary>
    /// Functions for working with AWS
    /// </summary>
    public static class Aws
    {
        /// <summary>
        /// Gets the Instance ID from AWS
        /// </summary>
        /// <returns>The AWS InstanceID, or a blank string if there was a problem.</returns>
        public static String GetInstanceID()
        {
            String instanceId = ""; // Initialize to blank string

            try {
                instanceId = RequestHelpers.Get("http://169.254.169.254/latest/meta-data/instance-id");   
            } catch (Exception e) {
                Console.WriteLine("Warning - could not capture instance id. Exception: " + e.ToString());
            }

            return instanceId;
        }
    }
}
