﻿using System;
namespace CBGModules
{
    /// <summary>
    /// Helpful functions for logging
    /// </summary>
    public static class Logger
    {
        /// <summary>
        /// Write the specified message and level to STDOUT and Syslog.
        /// Also triggers a pagerduty incident if parameter set to true and level is ERROR
        /// </summary>
        /// <returns>The write.</returns>
        /// <param name="message">The message.</param>
        /// <param name="level">The level. DEBUG, INFO, WARNING, ERROR</param>
        /// <param name="application">The application where the log originates from</param>
        /// <param name="pagerduty">If set to <c>true</c>, trigger pagerduty incidents</param>
        public static void Write(string message, string level, String application = "unknown", Boolean pagerduty = true)
        {
            Console.WriteLine("[" + level + "]" + " " + message); // Write the text to STDOUT
            Syslog.Write(message, level, application);

            // If it's an error, and pagerduty is
            if (pagerduty && level.ToLower() == "error") {
                PagerDuty.Trigger(message, "error");
            }
        }
    }
}
