﻿using System;
using System.Collections.Generic;
using Newtonsoft.Json;
using System.Net.Http;

namespace CBGModules
{
    /// <summary>
    /// Contains API Wrappers for PagerDuty
    /// </summary>
    public class PagerDuty
    {
        // PagerDuty variables
        // https://twitchoncall.pagerduty.com/services/P9GRQVZ/integrations
        private static string integration_key = "2818d3611a8e45238601e24063f98097";
        private static string endpoint = "https://events.pagerduty.com/v2/enqueue";

        /// <summary>
        /// Triggers a PagerDuty Incident
        /// </summary>
        /// <param name="message">The summary message to send to PagerDuty.</param>
        /// <param name="level">The level. This can be critical, error, warning or info</param>
        public static void Trigger(String message, String level)
        {
            String postJSON = BuildJsonBody(message, level);
            HttpContent postBody = RequestHelpers.JsonToHttp(postJSON);
            RequestHelpers.SendPostRequest(endpoint, postBody).Wait();
        }

        /// <summary>
        /// Builds a JSON Body to send to Syslog
        /// </summary>
        /// <returns>The json body.</returns>
        /// <param name="message">The summary message to send to PagerDuty.</param>
        /// <param name="level">The level. This can be critical, error, warning or info</param>
        private static String BuildJsonBody(string message, string level)
        {
            var postBody = new Dictionary<string, object>
            {
                { "routing_key", integration_key },
                { "event_action", "trigger" },
                { "payload", BuildPayload(message, level)}
            };

            return JsonConvert.SerializeObject(postBody);
        }

        /// <summary>
        /// Builds the PagerDuty payload.
        /// </summary>
        /// <returns>The payload.</returns>
        /// <param name="message">Message.</param>
        /// <param name="level">The level. This can be critical, error, warning or info</param>
        private static Dictionary<string, string> BuildPayload(string message, string level)
        {
            String instanceID = Aws.GetInstanceID();

            // If the instacne id couldn't be resolved, PD requires something
            if (string.IsNullOrEmpty(instanceID))
            {
                instanceID = "unknown";
            }

            var payload = new Dictionary<string, string>
            {
                { "summary", message },
                { "source", instanceID },
                { "severity", level},
                { "component", "Grid"}
            };

            return payload;
        }
    }
}
