﻿using System;
using System.Net.Http;
using System.Threading.Tasks;

namespace CBGModules
{
    /// <summary>
    /// Helpers for interacting with a REST Service
    /// </summary>
    public static class RequestHelpers
    {
        /// <summary>
        /// Make a GET Request
        /// </summary>
        /// <returns>The content</returns>
        /// <param name="url">URL to GET</param>
        public static String Get(string url) {
            Task<string> result = SendGetRequest(url);
            return result.Result;
        }

        /// <summary>
        /// Converts JSON to an HttpContent object
        /// </summary>
        /// <returns>The JSON in HttpContent</returns>
        /// <param name="jsonBody">Json body.</param>
        public static HttpContent JsonToHttp(String jsonBody)
        {
            HttpContent encodedContent = new StringContent(jsonBody);
            encodedContent.Headers.ContentType.MediaType = "application/json";
            encodedContent.Headers.ContentType.CharSet = ""; // Kibana breaks when passing charset
            return encodedContent;
        }

        /// <summary>
        /// Sends the post request.
        /// </summary>
        /// <returns>The post request.</returns>
        /// <param name="url">URL to POST to</param>
        /// <param name="body">The body to post</param>
        public static async Task SendPostRequest(String url, HttpContent body)
        {
            using (HttpClient httpClient = new HttpClient())
            {
                using (HttpResponseMessage response = await httpClient.PostAsync(url, body))
                {
                    if (!response.IsSuccessStatusCode)
                    {
                        using (HttpContent content = response.Content)
                        {
                            String respContent = await content.ReadAsStringAsync();
                            Console.WriteLine("The request was not successful.");
                            Console.WriteLine("Status code: " + response.StatusCode);
                            Console.WriteLine("Response content: " + respContent);
                        }
                    }
                }
            }

            body.Dispose();
        }

        private static async Task<string> SendGetRequest(string url) {
            using (HttpClient httpClient = new HttpClient())
            {
                httpClient.Timeout = new TimeSpan(0, 0, 2); // Timeout after two seconds
                using (HttpResponseMessage response = await httpClient.GetAsync(url))
                {
                    using (HttpContent content = response.Content)
                    {
                        string responseContent = await content.ReadAsStringAsync();
                        Console.WriteLine(responseContent);
                        return responseContent;
                    }
                }
            }
        }
    }
}
