# automation-webhooks
This repo contains automation scripts that run on Elastic Beanstalk and are triggered by webhooks


# Steps in Twitch's Docker-on-Beanstalk Deployment
1) build.json's "setup" generates base docker image used in jenkins build
   * It uses a devtools-provided golang base image
   * Docker image #1 is created here
2) build.json's "build" describes the steps to build the app in docker container.
   * Docker image #1 is launched, and the build steps run with the launched container. 
   * This generates docker image #2. This image is NOT used anywhere
3) The workspace directory in the container is exported to the outside as directory .manta
4) Dockerfile is then run to generate a docker image #3
   * during this process, the .manta directory is copied into the new image
   * NOTE: any customizations (eg installing packages) should go in here
   * Image is given canonical name docker-registry.internal.justin.tv/qe-automation-webhooks:$GIT_COMMIT
   * Image is pushed to devtools' docker registry
5) Next, when the deployment jenkins job run (eg triggered by clean-deploy):
   * it creates an .ebextension to customize the Beanstalk ec2 instance 
   * it creates a Dockerrun.aws.json (AWS specific) to tells Beanstalk how to launch a docker container 
       * docker image id (from step 4)is specified here
   * .ebextension and Dockerrun.aws.json are packaged into a zip file
   * Beanstalk CLI is invoked with the zipfile to deploy the app
   
 
 # Testing
1. Set these environment variables:
   * GITHUB_ACCESS_TOKEN=<create one at https://git-aws.internal.justin.tv/settings/tokens>
   * SLACK_API_TOKEN=<get from someone in the team>
   * JIRA_URL=https://jira.twitch.com
   * ENVIRONMENT=production
   * consumerkey=changereq
2. Get jira oauth credential files from someone in the team and save them in root directory of the project:
   * jira_token-bot.auth
   * jira-privkey.pem
3. go build main.go
4. ./main
5. (in another terminal console) ngrok http 8000
6. Get the internet https URL for the service from the output, something like:`https://eeaafcb4.ngrok.io -> localhost:8000`
7. Go to test repo settings, eg https://git-aws.internal.justin.tv/qe/exp-repo/settings/hooks, and add a webhook using the above URL, making sure "Disable SSL Verification" is checked.
8. Now, go to test repo and start testing  

Note, the unit tests can be run with the above environment variables and oauth credential files.
