package main

import (
	"fmt"
	"log"
	"net"
	"net/http"

	"code.justin.tv/qe/automation-webhooks/webhook"
	"github.com/zenazn/goji/graceful"
)

func init() {
	// "/" needs to return http status 200 in order to work in wpa2 network
	// Reference: https://jira.twitch.com/browse/SYS-12118
	http.HandleFunc("/", handleHello)

	changerequestHandler := &webhook.ChangeRequestHandler{}
	http.HandleFunc("/cr", changerequestHandler.Handler)

}

func main() {
	graceful.HandleSignals()

	listener, err := net.Listen("tcp", "0.0.0.0:8000") //nolint
	if err != nil {
		log.Fatalf("Error listening on port: %s", err.Error())
	}

	err = graceful.Serve(listener, http.DefaultServeMux)
	if err != nil {
		log.Fatalf("Error setting up handler on listener: %s", err.Error())
	}
	log.Printf("Server running...")
	graceful.Wait()
	log.Printf("Server shut down gracefully")
}

func handleHello(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintf(w, "Hello, %q", r.URL)
}
