package object

type Comment struct {
	Action  string
	Comment struct {
		ID   int `json:"id"`
		Body string
	} `json:"comment"`
	PullRequest struct {
		Number int
		Title  string
		Body   string
	} `json:"issue"`
	Branches []struct {
		Name string
	} `json:"branches"`
	Repository struct {
		FullName string `json:"full_name"`
	} `json:"repository"`
	Sender struct {
		Login string
	} `json:"sender"`
}

type RepositoryType struct {
	FullName string `json:"full_name"`
	URL      string
}
type CreateBranch struct {
	RefType      string `json:"ref_type"`
	MasterBranch string `json:"master_branch"`
	Ref          string
	Repository   struct {
		FullName string `json:"full_name"`
	} `json:"repository"`
	Sender struct {
		Login string
	} `json:"sender"`
}

// https://developer.github.com/v3/activity/events/types/#pullrequestevent
type PullRequest struct {
	Action     string
	Number     int
	Body       string
	Repository struct {
		FullName string `json:"full_name"`
	} `json:"repository"`
}

type GithubError struct {
	Message string `json:"message"`
	Errors  []struct {
		Resource string `json:"resource"`
		Field    string `json:"field"`
		Code     string `json:"code"`
	} `json:"errors"`
	DocumentationURL string `json:"documentation_url"`
}

type GithubRelease struct {
	Release struct {
		ID      int64  `json:"id"`
		Target  string `json:"target_commitish"`
		TagName string `json:"tag_name"`
		Name    string `json:"name"`
		Body    string `json:"body"`
	} `json:"release"`
	Repository struct {
		FullName string `json:"full_name"`
	} `json:"repository"`
	Sender struct {
		Login string
	} `json:"sender"`
}

type Ping struct {
	Hook struct {
		Type string
	}
	Sender struct {
		Login string
	}
}
