#!/bin/bash

set -e

ACCOUNT=$1

case "$ACCOUNT" in
        twitch-cape-qe-aws)
            ENVIRONMENTS=(production canary staging)
            ;;
        *)
            echo "Unknown account \"$ACCOUNT\", exiting"
            exit 1
esac

cd ./terraform/${ACCOUNT}

for ENVIRONMENT in "${ENVIRONMENTS[@]}"
do
    ROLE=`terraform output ${ENVIRONMENT}-iam_role_arn`

    tcs sandstorm role-flags \
        --owner team-qa-eng \
        --name qa-eng-${ENVIRONMENT}-automation-webhooks \
        --secret_key "qa-eng/automation-webhooks/${ENVIRONMENT}/*" \
        --allowed_arn "${ROLE}" \
        --output ./sandstorm.d/${ACCOUNT}_${ENVIRONMENT}.json

done
