

module "bs-staging" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-cape-qe-aws"
  aws_region = "us-west-2"
  eb_application_name = "${module.bs-app-twitch-cape-qe-aws.beanstalk_application_name}"
  vpc_id = "vpc-25d89842"
  ec2_subnet_ids = "subnet-cf9a03a8,subnet-b3b102fa,subnet-c83d2990"
  elb_subnet_ids = "subnet-cf9a03a8,subnet-b3b102fa,subnet-c83d2990"
  elb_loadbalancer_security_groups = "sg-09687471"
  auto_scaling_lc_security_groups = "sg-09687471"
  solution_stack_name = "64bit Amazon Linux 2018.03 v2.12.2 running Docker 18.03.1-ce"
  auto_scaling_lc_instance_type = "t2.micro"
  owner = "qe-team@twitch.tv"
  service = "qe/automation-webhooks"
  env = "staging"
  associate_public_address = "false"
  cname_prefix = "qe-automation-webhooks-staging"

}

resource "aws_dynamodb_table" "repodata-staging" {
  name = "repodata-staging"
  read_capacity  = "1"
  write_capacity = "1"

  hash_key = "repo"

  attribute {
    name = "repo"
    type = "S"
  }
}