//nolint
package tests

import (
	"code.justin.tv/qe/automation-webhooks/task"
	"code.justin.tv/qe/automation-webhooks/util"
	"strings"
	"testing"
)

const testProjectKey = "BPP"

// dev jira is not usable - remove "RUN_LOCALLY_ONLY_" to run tests against prod jira locally
func RUN_LOCALLY_ONLY_TestJiraClient(t *testing.T) {
	jiraHelper := util.GetJiraHelperInstance()
	if jiraHelper == nil {
		t.Fatalf("Failed to instantiate jira helper")
	}
	issues, resp, err := jiraHelper.SearchIssues("project='Quality Engineering'")
	if issues == nil {
		t.Fatalf("Failed to return issues in search query")
	}
	if resp == nil {
		t.Fatalf("Failed to return response in search query")
	}
	if err != nil {
		t.Fatalf("search query returned non-nil")
	}
}

// dev jira is not usable - remove "RUN_LOCALLY_ONLY_" to run tests against prod jira locally
func RUN_LOCALLY_ONLY_TestJiraGetIssue(t *testing.T) {
	jiraHelper := util.GetJiraHelperInstance()
	if jiraHelper == nil {
		t.Fatalf("Failed to instantiate jira helper")
	}
	issues, resp, err := jiraHelper.SearchIssues("project='Quality Engineering'")
	if issues == nil {
		t.Fatalf("Failed to return issues in search query")
	}
	if resp == nil {
		t.Fatalf("Failed to return response in search query")
	}
	if err != nil {
		t.Fatalf("search query returned non-nil")
	}
	deepIssue, err := jiraHelper.GetIssue("BPP-208")
	if err != nil || deepIssue == nil {
		t.Fatalf("Failed to get issue")
	} else {
		t.Logf("issue key=%s", deepIssue.Fields.Unknowns)
	}
}

// dev jira is not usable - remove "RUN_LOCALLY_ONLY_" to run tests against prod jira locally
func RUN_LOCALLY_ONLY_TestJiraClientCreateIssue(t *testing.T) {
	jiraHelper := util.GetJiraHelperInstance()
	if jiraHelper == nil {
		t.Fatalf("Failed to instantiate jira helper")
	}

	customFields := map[string]string{
		"Change Start Date/Time":      "2017-03-01 12:30",
		"Change End Date/Time":        "2017-04-01 13:30",
		"Change Type":                 "Feature Release",
		"Change Risk":                 "Low",
		"Success Criteria":            "it works",
		"Evidence of Testing":         "i tested locally",
		"Architectural Specification": "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Product Specification":       "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Deployment Plan":             "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Rollback Plan":               "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Self Approve?":               "Yes",
	}
	issue, err := jiraHelper.CreateIssue(testProjectKey, "Change Request", "test summary", "test descriptipn", customFields)
	if err != nil || issue == nil {
		t.Fatalf("Failed to create query")
	} else {
		t.Logf("issue key=%s", issue.Key)
	}
}

// dev jira is not usable - remove "RUN_LOCALLY_ONLY_" to run tests against prod jira locally
func RUN_LOCALLY_ONLY_TestJiraClientCreateIssueOverrideReporter(t *testing.T) {
	jiraHelper := util.GetJiraHelperInstance()
	if jiraHelper == nil {
		t.Fatalf("Failed to instantiate jira helper")
	}

	customFields := map[string]string{
		"Change Start Date/Time":      "2018-03-01 12:30",
		"Change End Date/Time":        "2018-04-01 13:30",
		"Change Type":                 "Feature Release",
		"Change Risk":                 "Low",
		"Success Criteria":            "it works",
		"Evidence of Testing":         "i tested locally",
		"Architectural Specification": "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Product Specification":       "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Deployment Plan":             "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Rollback Plan":               "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Reporter":                    "lukemng",
	}
	issue, err := jiraHelper.CreateIssue(testProjectKey, "Change Request", "test summary", "test descriptipn", customFields)
	if err != nil || issue == nil {
		t.Fatalf("Failed to create ticket")
	} else {
		t.Logf("issue key=%s", issue.Key)
		deepIssue, err := jiraHelper.GetIssue(issue.Key)
		if err != nil {
			t.Fatalf("Failed to get full issue")
		} else {
			if deepIssue.Fields.Reporter.Key != customFields["Reporter"] {
				t.Fatalf("Reporter override failed to persist in ticket")
			}
		}
	}
}

// dev jira is not usable - remove "RUN_LOCALLY_ONLY_" to run tests against prod jira locally
func RUN_LOCALLY_ONLY_TestJiraClientUpdateIssueLabel(t *testing.T) {
	jiraHelper := util.GetJiraHelperInstance()
	if jiraHelper == nil {
		t.Fatalf("Failed to instantiate jira helper")
	}

	customFields := map[string]string{
		"Change Start Date/Time":      "2017-03-01 12:30",
		"Change End Date/Time":        "2017-04-01 13:30",
		"Change Type":                 "Feature Release",
		"Change Risk":                 "Low",
		"Success Criteria":            "it works",
		"Evidence of Testing":         "i tested locally",
		"Architectural Specification": "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Product Specification":       "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Deployment Plan":             "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Rollback Plan":               "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Reporter":                    "lukemng",
	}
	updateFields := map[string]string{
		"Labels": "GitHub-CR",
	}
	issue, err := jiraHelper.CreateIssue(testProjectKey, "Change Request", "test summary", "test descriptipn", customFields)
	if err != nil || issue == nil {
		t.Fatalf("Failed to create ticket")
	} else {
		t.Logf("issue key=%s", issue.Key)
		issue, err = jiraHelper.UpdateIssue(issue.Key, updateFields)
		if err != nil {
			t.Fatalf("Failed to update issue")
		} else {
			t.Log(issue.Fields.Labels)
		}
	}
}

// dev jira is not usable - remove "RUN_LOCALLY_ONLY_" to run tests against prod jira locally
func RUN_LOCALLY_ONLY_TestJiraClientUpdateIssueLabelExistingTicket(t *testing.T) {
	jiraHelper := util.GetJiraHelperInstance()
	if jiraHelper == nil {
		t.Fatalf("Failed to instantiate jira helper")
	}
	updateFields := map[string]string{
		"Labels": "GitHub-CR",
	}
	issue, err := jiraHelper.UpdateIssue("QE-927", updateFields)
	if err != nil {
		t.Fatalf("Failed to update issue")
	} else {
		t.Logf("issue labels=%s", issue.Fields.Labels)
	}
}

func TestGithubGetPR(t *testing.T) {
	helper := &util.GithubHelper{}
	helper.Init()
	pr, resp, err := helper.GetPR("qe/oml", 47)
	if pr == nil {
		t.Fatalf("Failed to return issues in search query")
	}
	if resp == nil {
		t.Fatalf("Failed to return response in search query")
	}
	if err != nil {
		t.Fatalf("search query returned non-nil")
	}
}

func TestSlackFindUser(t *testing.T) {
	helper := util.GetSlackHelperInstance()
	githubUserId := "lukemng"
	githubRealName := ""
	user, err := helper.FindMatchingUser(githubUserId, githubRealName)
	if err != nil {
		t.Fatalf("Failed due to: %s", err.Error())
	}
	if user == nil {
		t.Logf("Failed to find expected user %s", githubUserId)
	}
	t.Logf("%v", user)
}

func TestSlackFindUserWithInconsistentUserId(t *testing.T) {
	helper := util.GetSlackHelperInstance()
	githubUserId := "jerchang" // bad userid. doesn't match with other systems
	githubRealName := "Jeremy Chang"
	user, err := helper.FindMatchingUser(githubUserId, githubRealName)
	if err != nil {
		t.Fatalf("Failed due to: %s", err.Error())
	}
	if user == nil {
		t.Fatalf("Failed to find expected user")
	}
	t.Logf("%v", user)
}

func TestSlackDirectMessage(t *testing.T) {
	helper := util.GetSlackHelperInstance()
	user, err := helper.FindMatchingUser("lukemng", "")
	if err != nil {
		t.Fatalf("Failed due to: %s", err.Error())
	}

	err = helper.DirectMessage(user, "This message is brought to you by slack helper")
	if err != nil {
		t.Fatalf("Failed due to: %s", err.Error())
	}
}

// dev jira is not usable - remove "RUN_LOCALLY_ONLY_" to run tests against prod jira locally
func RUN_LOCALLY_ONLY_TestJiraClientCreateIssueWithPlatformUpdateLabel(t *testing.T) {
	jiraHelper := util.GetJiraHelperInstance()
	if jiraHelper == nil {
		t.Fatalf("Failed to instantiate jira helper")
	}

	customFields := map[string]string{
		"Change Start Date/Time":      "2017-03-01 12:30",
		"Change End Date/Time":        "2017-04-01 13:30",
		"Change Type":                 "Feature Release",
		"Change Risk":                 "Low",
		"Success Criteria":            "it works",
		"Evidence of Testing":         "i tested locally",
		"Architectural Specification": "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Product Specification":       "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Deployment Plan":             "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Rollback Plan":               "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Platform":                    "Android",
	}
	issue, err := jiraHelper.CreateIssue(testProjectKey, "Change Request", "test summary", "test descriptipn", customFields)
	issue, err = jiraHelper.GetIssue(issue.Key)
	if err != nil || issue == nil {
		t.Fatalf("Failed to create ticket")
	} else {
		t.Logf("issue key=%s", issue.Key)
		allTheLabels := append(issue.Fields.Labels, "GitHub-CR")
		labelMap := map[string]string{"Labels": strings.Join(allTheLabels, ",")}
		issue, err = jiraHelper.UpdateIssue(issue.Key, labelMap)
		if err != nil {
			t.Fatalf("Failed due to: %s", err.Error())
		}
		t.Logf("final labels=%s", strings.Join(issue.Fields.Labels, ","))
	}
}

// dev jira is not usable - remove "RUN_LOCALLY_ONLY_" to run tests against prod jira locally
func RUN_LOCALLY_ONLY_TestJiraFindUsers(t *testing.T) {
	jiraHelper := util.GetJiraHelperInstance()
	users, _, _ := jiraHelper.FindUsers("bach")
	for _, u := range *users {
		t.Logf("%s, %s", u.Name, u.DisplayName)
	}
}

// dev jira is not usable - remove "RUN_LOCALLY_ONLY_" to run tests against prod jira locally
func RUN_LOCALLY_ONLY_TestChangeRequestFindUsers(t *testing.T) {
	g := &util.GithubHelper{}
	g.Init()
	task := task.ChangeRequestTask{}

	// this is actual test of known edge cases
	// jchang (github)- jerchang (jira)
	// bach (github) - bachn (jira)
	// jmizzoni (github) - jmizzon (jira)
	for _, search := range []string{"jchang", "bach", "jmizzoni"} {
		jiraUser, err := task.FindJiraUser(search)
		if err != nil {
			t.Fatalf("failed to find jira user for github user %s due to: %s", search, err.Error())
		} else {
			t.Logf("github userid: %s, jira user id = %s", search, jiraUser)
		}
	}
}

func TestGithubListReleases(t *testing.T) {
	helper := &util.GithubHelper{}
	helper.Init()
	releases, resp, err := helper.ListReleases("twilight/twilight")
	if releases == nil {
		t.Fatalf("Failed to return releases")
	}
	if resp == nil {
		t.Fatalf("Failed to return response in search query")
	}
	if err != nil {
		t.Fatalf("search query returned non-nil")
	}

}

func TestDynamoDB(t *testing.T) {
	issue, err := util.GetJiraHelperInstance().GetIssue("CVP-1982")
	if err != nil {
		t.Fatalf("failed to get issue")
	}

	dynamo := util.NewDynamoDBHelper("repodata-staging")
	dynamo.PutRepoData("qe/test-repo", issue)
	repoData, err := dynamo.GetRepoData("qe/test-repo")
	if err != nil {
		t.Fatalf("failed to get repo data from dynamo")
	}
	if len(repoData.ServicesImpacted) == 0 {
		t.Fatalf("failed validation of services impacted in persisted entity")
	}
}

func TestServiceCatalogHelper(t *testing.T) {
	serviceCatHelper := util.NewServiceCatalogHelper()
	services, err := serviceCatHelper.ListServices()
	if err != nil {
		t.Fatalf("Got error calling ListServices: %s", err.Error())
	}
	for _, name := range services.Data.Services {
		t.Logf("service: %s", name.Name)
	}
}

// dev jira is not usable - remove "RUN_LOCALLY_ONLY_" to run tests against prod jira locally
func RUN_LOCALLY_ONLY_TestJiraClientUpdateIssueWithServicesImpacted(t *testing.T) {
	jiraHelper := util.GetJiraHelperInstance()
	if jiraHelper == nil {
		t.Fatalf("Failed to instantiate jira helper")
	}

	customFields := map[string]string{
		"Change Start Date/Time":      "2017-03-01 12:30",
		"Change End Date/Time":        "2017-04-01 13:30",
		"Change Type":                 "Feature Release",
		"Change Risk":                 "Low",
		"Success Criteria":            "it works",
		"Evidence of Testing":         "i tested locally",
		"Architectural Specification": "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Product Specification":       "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Deployment Plan":             "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Rollback Plan":               "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Reporter":                    "lukemng",
	}
	updateFields := map[string]string{
		"Services Impacted": "Global Change, Users",
	}
	issue, err := jiraHelper.CreateIssue(testProjectKey, "Change Request", "test summary", "test descriptipn", customFields)
	if err != nil || issue == nil {
		t.Fatalf("Failed to create ticket")
	} else {
		t.Logf("issue key=%s", issue.Key)
		issue, err = jiraHelper.UpdateIssue(issue.Key, updateFields)
		if err != nil && issue == nil {
			t.Fatalf("Failed to update issue")
		} else {
			t.Log(issue.Fields.Labels)
		}
	}
}

// dev jira is not usable - remove "RUN_LOCALLY_ONLY_" to run tests against prod jira locally
func RUN_LOCALLY_ONLY_TestJiraClientUpdateIssueWithInvalidServicesImpacted(t *testing.T) {
	jiraHelper := util.GetJiraHelperInstance()
	if jiraHelper == nil {
		t.Fatalf("Failed to instantiate jira helper")
	}

	customFields := map[string]string{
		"Change Start Date/Time":      "2017-03-01 12:30",
		"Change End Date/Time":        "2017-04-01 13:30",
		"Change Type":                 "Feature Release",
		"Change Risk":                 "Low",
		"Success Criteria":            "it works",
		"Evidence of Testing":         "i tested locally",
		"Architectural Specification": "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Product Specification":       "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Deployment Plan":             "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Rollback Plan":               "https://wiki.twitch.com/display/~lukemng/Automated+CR+Creation",
		"Reporter":                    "lukemng",
	}
	updateFields := map[string]string{
		"Services Impacted": "Global Change, Users, THIS IS INVALID",
	}
	issue, err := jiraHelper.CreateIssue(testProjectKey, "Change Request", "test summary", "test descriptipn", customFields)
	if err != nil || issue == nil {
		t.Fatalf("Failed to create ticket")
	} else {
		t.Logf("issue key=%s", issue.Key)
		issue, err = jiraHelper.UpdateIssue(issue.Key, updateFields)
		if err != nil && issue == nil {
			t.Fatalf("Completely failed to update issue")
		} else if err != nil {
			t.Log(issue.Fields.Labels)
			t.Logf("Partially updated issue. Test passed")
		} else {
			t.Log(issue.Fields.Labels)
			t.Fatalf("Test failed: issue completely updated, which is unexpected")
		}
	}
}

// dev jira is not usable - remove "RUN_LOCALLY_ONLY_" to run tests against prod jira locally
func RUN_LOCALLY_ONLY_TestJiraPostComment(t *testing.T) {
	jiraHelper := util.GetJiraHelperInstance()
	if jiraHelper == nil {
		t.Fatalf("Failed to instantiate jira helper")
	}
	comment, err := jiraHelper.PostComment("QE-927", "jira helper successfully posted comment")
	if err != nil || comment == nil {
		t.Fatalf("Failed to get comment")
	} else {
		t.Logf("comment text=%s", comment.Body)
	}
}
