package util

import (
	"fmt"
	"log"

	"github.com/pkg/errors"
)

func LogAndReturnError(err error, messageFormat string, v ...interface{}) error {
	//TODO: consider the recommendations on https://github.com/golang/go/wiki/CodeReviewComments#error-strings
	message := ""
	if v == nil {
		message = messageFormat
	} else {
		message = fmt.Sprintf(messageFormat, v...)
	}
	log.Println(message)
	if err == nil {
		return errors.New(message)
	} else {
		return errors.Wrap(err, message)
	}
}
