package util

import (
	"bytes"
	"encoding/json"
	"io/ioutil"
	"net/http"

	"code.justin.tv/qe/automation-webhooks/object"
)

const (
	ServiceCatalogEndpoint  = "https://servicecatalog-api.internal.justin.tv/api/v2/query"
	ListServiceNamesGraphql = `{"operationName":"FetchAllServices", "variables":{}, "query":"query FetchAllServices {services{name, state}}"}`
)

// ServiceCatalogHelper struct
type ServiceCatalogHelper struct {
}

// NewServiceCatalogHelper instantiates a new ServiceCatalogHelper
func NewServiceCatalogHelper() *ServiceCatalogHelper {
	return &ServiceCatalogHelper{}
}

// ListServices lists all services known to Service Catalog
func (s *ServiceCatalogHelper) ListServices() (*object.Services, error) {
	var payload = []byte(ListServiceNamesGraphql)
	req, err := http.NewRequest("POST", ServiceCatalogEndpoint, bytes.NewBuffer(payload))
	if err != nil {
		return nil, err
	}

	client := &http.Client{}
	resp, err := client.Do(req)
	if err != nil {
		return nil, err
	}
	defer resp.Body.Close()

	bodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return nil, err
	}
	var services object.Services
	err = json.Unmarshal(bodyBytes, &services)
	if err != nil {
		return nil, err
	}

	return &services, err
}
