# BrowserMob Proxy
This Repository is used to store the Terraform Configuration and Docker image for BrowserMob Proxy

For more info on BMP, see:
https://github.com/lightbody/browsermob-proxy/

It's running at:
http://bmp.us-west2.justin.tv:9090/proxy

## Infrastructure
BMP runs in a Docker Container on an EC2 Instance. A Route53 address is used to connect users to the instance.

The infrastructure is configured via [Terraform](terraform).

### Setup
This was designed for MacOS

### Install Terraform
Download Terraform: https://www.terraform.io/downloads.html

Unzip & move the downloaded executable to `/usr/local/bin/`

```
sudo mv ~/Downloads/terraform /usr/local/bin/terraform
```

Ensure it works! `terraform -v`

### Install AWS CLI

#### Python
If you don't yet have a non-system version of Python installed, configure pyenv:
https://github.com/pyenv/pyenv#homebrew-on-macos

And then
```
pyenv install-latest
```

Search the Versions
```
pyenv versions
```

and then set the verison you just downloaded as global (this example is 3.7.2)
```
pyenv global 3.7.2
```

#### Pip
Install Pip:
https://pip.pypa.io/en/stable/installing/

#### AWS CLI
https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-install.html

#### AWS Credentials
Create a file in `~/.aws/credentials` with the following template:
```
[twitch-science-aws]
aws_access_key_id = <YOUR_ACCESS_KEY>
aws_secret_access_key = <YOUR_SECRET_KEY>
[twitch-video-aws]
aws_access_key_id = <YOUR_ACCESS_KEY>
aws_secret_access_key = <YOUR_SECRET_KEY>
```

If you use IAM Credentials, place your access key and secret key where fit.

If you use Isengard:
You'll have to use ADA, which will fetch your temporary credentials from Isengard
and place them in the credentials file.

1) Install Toolbox: https://w.amazon.com/index.php/BuilderToolbox/GettingStarted#Install_Toolbox
2) Install ADA: https://w.amazon.com/bin/view/DevAccount/Docs/#HInstallation

For Twitch Science (which is what houses the Route53 Address)

```
ada credentials update --account=673385534282 --provider=isengard --role=DNS --profile=twitch-science-aws
```

For twitch-video-aws, use the above as a template. Fetch the account number, role, and use `--profile=twitch-video-aws`

### Running
Running Terraform will modify the infrastructure as needed.
It's recommended you always plan (which does a dry-run) before you apply!

```
cd terraform
terraform plan
terraform apply
```

## Docker Image
- [browsermob-proxy-2.1.4](https://github.com/lightbody/browsermob-proxy/releases/tag/browsermob-proxy-2.1.4) on port 9090 using littleproxy.
- expose 30 ports for proxy listeners in range 9091-9121
- clean up proxy listener port after 240 seconds of inactivity

Forked from https://github.com/rubytester/docker-browsermob-proxy

### Usage

ENV Params:
- `JAVA_OPTS`: opts to the JVM, defaults to -Xmx1024m
- `BMP_OPTS`: opts to browsermob-proxy, defaults to "-port 9090 --use-littleproxy true -proxyPortRange 9091-9121 -ttl 60"

```
    docker run -p 9090-9121:9090-9121 docker-registry.internal.justin.tv/qa/browsermob-proxy:2.1.4

    # override JAVA_OPTS
    docker run -p 9090-9121:9090-9121 -e JAVA_OPTS="-Xmx4G" docker-registry.internal.justin.tv/qa/browsermob-proxy:2.1.4

    # override BMP_OPTS
    docker run -p 9090-9092:9090-9092 -e BMP_OPTS="-port 9090 --use-littleproxy true -proxyPortRange 9091-9092 -ttl 10" docker-registry.internal.justin.tv/qa/browsermob-proxy:2.1.4
```

### Available Images

All available Docker images of BrowserMob Proxy are available [here][1].

BrowserMob Proxy releases are available at:
https://github.com/lightbody/browsermob-proxy/releases

### Building New Images

Only tested running on a Linux box, but theoretically should work on OS X as well.

Docker [must be installed](https://docs.docker.com/engine/installation/).

Clone Repo
```
cd ~/twitch
git clone git@git-aws.internal.justin.tv:qe/browsermob_proxy.git
cd browsermob_proxy
```

Find the version you want to update to. Copy the .zip download link.
https://github.com/lightbody/browsermob-proxy/releases

Create new branch.

Update within the `Dockerfile` where we curl for the download link.

When finished updating files, build the image. Make sure you cd into the folder where `Dockerfile` is and run:

`docker build -t browsermob-proxy:VERSION_NUMBER .`

Replace VERSION_NUMBER with the version of BMP. For example,` browsermob-proxy:2.1.4`

When built, verify it by running it locally. If it starts the container and looks good, push it up to our Docker Registry:
docker-registry.internal.justin.tv

1. Find the image you just created and grab its Image ID. `docker images`
2. Type `docker tag IMAGE_ID docker-registry.internal.justin.tv/qa/browsermob-proxy:VERSION_NUMBER`
3. Type `docker images` to verify the image repository changed
4. Type `docker push docker-registry.internal.justin.tv/qa/browsermob-proxy:VERSION_NUMBER`

### Example

![Docker Image Tagging](../docs/images/docker_image_tagging.png)

**Do Not Run the below commands, as it may overwrite our actual image. These are only for reference**

In the above example, we updated to BrowserMob Proxy 2.1.4 and built the container using:

`docker build -t browsermob-proxy:2.1.4 .`

We ran `docker images` and found its image ID was `0d77f9ebfe7c`

We then tagged it to the internal registry using:

`docker tag 0d77f9ebfe7c docker-registry.internal.justin.tv/qa/browsermob-proxy:2.1.4`

We then pushed it to the repository:

`docker push docker-registry.internal.justin.tv/qa/browsermob-proxy:2.1.4`

### References

- [How To Use Your Own Registry](https://blog.docker.com/2013/07/how-to-use-your-own-registry/)
- [Docker Registry BMP Versions][1]

[1]: https://docker-registry.internal.justin.tv/v2/qa/browsermob-proxy/tags/list
