# The Route53 Zone for .us-west2.justin.tv, defined in twitch-aws
variable r53_zone {
  default = "ZRG00SM48517Z"
}

# Xenial AMI from Devtools: devtools-baseami-xenial-us-west-2-1512777553
# Refer to https://wiki.twitch.com/display/DTA/Base+AMI
variable "ami" {
  default = "ami-077fa6690bcdc8a60"
}

# https://git-aws.internal.justin.tv/systems/puppet/blob/master/hiera/cluster/qa-browsermob-proxy.yaml
# These are recognizable by puppet, so that it knows which docker images to run
variable "cluster" {
  default = "qa-browsermob-proxy"
}

# The VPC to run the instances in
variable vpc_id {
  default = "vpc-cae782af"
}

# The subnet to run the instances in - NAT A
variable subnet_id {
  default = "subnet-31db4147"
}

###################
# Production Node #
###################

module "production_4_17_18" {
  source = "modules/grid-ec2"
  name = "browsermob-proxy"
  ami = "${var.ami}"
  owner = "dylan"
  cluster = "${var.cluster}"
  environment = "prod"
  count = "1"
  node_instance = "c4.xlarge"
  security_group = "${aws_security_group.bmp.id}"
  vpc_id = "${var.vpc_id}"
  subnet_id = "${var.subnet_id}"
}

# Route53 Record - Create a DNS Record to give it a URL
resource "aws_route53_record" "prod_r53" {
  provider = "aws.twitch-science-aws"
  zone_id = "${var.r53_zone}"
  name = "bmp"
  type = "A"
  ttl = "300"
  records = ["${module.production_4_17_18.private_ip}"]
}

output "prod_fqdn" {
  value = "${aws_route53_record.prod_r53.fqdn}"
}

################
# Staging Node #
################

module "staging" {
  source = "modules/grid-ec2"
  name = "browsermob-proxy"
  ami = "${var.ami}"
  owner = "dylan"
  cluster = "${var.cluster}"
  environment = "staging"
  count = "1"
  node_instance = "t3.small"
  security_group = "${aws_security_group.bmp.id}"
  vpc_id = "${var.vpc_id}"
  subnet_id = "${var.subnet_id}"
}

# Route53 Record - Create a DNS Record to give it a URL
resource "aws_route53_record" "staging_r53" {
  provider = "aws.twitch-science-aws"
  zone_id = "${var.r53_zone}"
  name = "bmp-staging"
  type = "A"
  ttl = "300"
  records = ["${module.staging.private_ip}"]
}

output "staging_fqdn" {
  value = "${aws_route53_record.staging_r53.fqdn}"
}
