# This module serves to create EC2 instances for Selenium Grid nodes.
# Variables of Owner, Cluster, Count and node_instance must be passed in

variable name {}
variable owner {} # The owner of the instance
variable cluster {} # The cluster type, which puppet will read from

# The VPC to run the instances in
variable vpc_id {}

# The subnet to run the instances in
variable subnet_id {}

# The security group to use for the BMP Instance
variable security_group {}

# The amount of instances to spin up
variable count {
  default = 1
}

variable node_instance {} # The size of the box. I.e., c3.large
variable root_block_volume_size { # The size of the volume, in GBs
  default = "8"
}
variable max_cpu_threshold_alarm { # Max CPU Usage before monitoring fails, defaulted to 75%
  default = "75"
}

# Xenial AMI from Devtools: devtools-baseami-xenial-us-west-2-1512777553
# Refer to https://wiki.twitch.com/display/DTA/Base+AMI
variable "ami" {
  default = "ami-077fa6690bcdc8a60"
}
variable "environment" {
  default = "prod"
}

resource "aws_instance" "node" {
  ami = "${var.ami}"
  count = "${var.count}"
  instance_type = "${var.node_instance}"

  # Security/Subnet Groups for internal access only
  vpc_security_group_ids = ["${var.security_group}"]
  subnet_id = "${var.subnet_id}"
  associate_public_ip_address = false

  # Run puppet when starting
  # Set the hostname to something unique - using the instance ID
  user_data = <<END_OF_STRING
#cloud-config
preserve_hostname: true
bootcmd:
 - cloud-init-per instance my_set_hostname sh -xc "echo "${var.cluster}-$INSTANCE_ID" | sed -e 's/-i-/-/g' > /etc/hostname; hostname -F /etc/hostname"
 - cloud-init-per instance my_etc_hosts sh -xc "sed -i -e '/^127.0.1.1/d' /etc/hosts; echo 127.0.1.1 $(cat /etc/hostname).dev.us-west2.justin.tv $(cat /etc/hostname) >> /etc/hosts"
runcmd:
 - echo "cluster=${var.cluster}" > /etc/facter/facts.d/cluster.txt
 - echo "clean=true" > /etc/facter/facts.d/clean.txt
 - puppet agent --test --server=puppet.internal.justin.tv
END_OF_STRING

  tags {
    Name = "${var.name}-${var.environment}" # Ex: selenium-node-firefox-4
    Owner = "${var.owner}"
    Service = "BMP"
    Environment = "${var.environment}"
  }

  root_block_device {
    volume_size = "${var.root_block_volume_size}"
  }
}

output "private_ip" {
  value = "${aws_instance.node.0.private_ip}"
}
