# All of the twitch internal cidrs
# Ideally we get it from a central source in the future
variable "twitch_subnets" {
  default = [
    "10.0.0.0/8",
    "192.16.64.0/21",
    "199.9.248.0/21",
    "185.42.204.0/22",
    "127.0.0.1/32",
    "38.99.10.96/29",
    "38.99.7.224/27",
    "38.104.129.210/32",
    "69.85.223.168/29",
    "192.168.0.0/16",
    "45.113.128.0/22",
    "103.53.48.0/22",
    "192.108.239.0/24",
    "23.160.0.0/24",
    "52.223.192.0/18",
    "98.173.4.128/27",
    "12.245.210.116/30",
    "54.240.196.173/32",
    "54.240.198.32/29",
    "204.246.162.32/28",
    "205.251.237.64/28",
    "205.251.237.96/28",
    "52.95.4.0/25",
    "54.240.217.8/29",
    "54.240.217.16/29",
    "72.21.196.64/29",
    "72.21.198.64/29",
    "99.181.64.0/18",
  ]
}

resource "aws_security_group" "bmp" {
  name = "browsermob_proxy"
  description = "Allows access to/from all Twitch Subnets for BrowserMob Proxy"
  vpc_id = "${var.vpc_id}"

  tags {
    Name = "browsermob_proxy"
    Owner = "Player"
    Team = "Player"
  }
}

resource "aws_security_group_rule" "allow_connections_from_twitch_subnets" {
  security_group_id = "${aws_security_group.bmp.id}"
  type = "ingress"
  from_port = 0
  to_port = 65535
  protocol = "tcp"
  cidr_blocks = ["${var.twitch_subnets}"]
}

resource "aws_security_group_rule" "allow_outbound_connections" {
  security_group_id = "${aws_security_group.bmp.id}"
  type = "egress"
  from_port = 0
  to_port = 65535
  protocol = "all"
  cidr_blocks = ["0.0.0.0/0"]
}
