resource "aws_iam_role" "jenkins" {
  name = "jenkins_chef_builder"
  description = "Allows Jenkins to Manage Chef Builder"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": {
        "AWS": [
          "arn:aws:iam::043714768218:role/jenkins-prod-master",
          "arn:aws:iam::043714768218:role/jenkins-prod-slave"
        ]
      },
      "Action": "sts:AssumeRole"
    }
  ]
}
EOF
}

// Push images to ECR
resource "aws_iam_role_policy" "manage_ecr" {
  name = "Manage-ECR"
  role = aws_iam_role.jenkins.id

  policy = <<-EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Sid": "AllowPush",
      "Action": [
        "ecr:BatchCheckLayerAvailability",
        "ecr:DescribeImages",
        "ecr:DescribeRepositories",
        "ecr:InitiateLayerUpload",
        "ecr:PutImage",
        "ecr:PutImageScanningConfiguration",
        "ecr:PutImageTagMutability",
        "ecr:PutLifecyclePolicy",
        "ecr:UploadLayerPart"
      ],
      "Effect": "Allow",
      "Resource": "${aws_ecr_repository.chef_builder.arn}"
    },
    {
        "Sid": "AuthToken",
        "Effect": "Allow",
        "Action": "ecr:GetAuthorizationToken",
        "Resource": "*"
    }
  ]
}
  EOF
}
