resource "aws_ecr_repository" "chef_builder" {
  name = "twitch_chef_builder"
}

variable "allowed_roles_push" {
  type = list
  default = [
    "arn:aws:iam::147030575244:role/jenkins_chef_builder",
  ]
}

variable "allowed_roles_pull" {
  type = list
  default = [
    "arn:aws:iam::147030575244:role/jenkins_grid_artifact_upload",
  ]
}

resource "aws_ecr_repository_policy" "access_policy" {
  repository = aws_ecr_repository.chef_builder.name

  policy = <<EOF
{
    "Version": "2008-10-17",
    "Statement": [
        {
            "Sid": "AllowPush",
            "Effect": "Allow",
            "Principal": {
                "AWS": ${jsonencode(var.allowed_roles_push)}
            },
            "Action": [
              "ecr:BatchCheckLayerAvailability",
              "ecr:CompleteLayerUpload",
              "ecr:DescribeImages",
              "ecr:DescribeRepositories",
              "ecr:InitiateLayerUpload",
              "ecr:PutImage",
              "ecr:PutImageScanningConfiguration",
              "ecr:PutImageTagMutability",
              "ecr:PutLifecyclePolicy",
              "ecr:UploadLayerPart"
            ]
        },
        {
            "Sid": "AllowPull",
            "Effect": "Allow",
            "Principal": {
                "AWS": ${jsonencode(var.allowed_roles_pull)}
            },
            "Action": [
                "ecr:BatchCheckLayerAvailability",
                "ecr:GetDownloadUrlForLayer",
                "ecr:GetRepositoryPolicy",
                "ecr:DescribeRepositories",
                "ecr:ListImages",
                "ecr:DescribeImages",
                "ecr:BatchGetImage"
            ]
        }
    ]
}
EOF
}

# Delete untagged images
resource "aws_ecr_lifecycle_policy" "GridDeleteImagePolicy" {
  repository = aws_ecr_repository.chef_builder.name

  policy = <<EOF
{
    "rules": [
        {
            "rulePriority": 1,
            "description": "Expire images older than 30 days",
            "selection": {
                "tagStatus": "untagged",
                "countType": "sinceImagePushed",
                "countUnit": "days",
                "countNumber": 30
            },
            "action": {
                "type": "expire"
            }
        }
    ]
}
EOF
}
