# ci_trigger
[![Build Status](https://jenkins-og.xarth.tv/buildStatus/icon?job=browser-grid-tc-trigger)](https://jenkins-og.xarth.tv/job/browser-grid-tc-trigger/)

Triggers CI Builds (Teamcity/Jenkins)

This folder contains scripts used for triggering Grid client's test builds.
This is used for integration testing Browser Grid changes, so that we can ensure changes don't break client's framework.

## Multiple Triggers
Sometimes we may want to trigger builds multiple times, such as when validating a Browser Upgrade.
This ensures there are not flakey/inconsistent results

A job was created to trigger the integration test job multiple times:
[![Build Status](https://jenkins-og.xarth.tv/buildStatus/icon?job=browser-grid-tc-trigger-multi)](https://jenkins-og.xarth.tv/job/browser-grid-tc-trigger-multi/)

## Adding/Modifying a Job
Modify config.json by adding to the array:

| Property Name | Type | Description |
|---| ---| --- |
| job_id | String |The TeamCity (buildTypeId) or Jenkins Job Name |
| platform | String | currently only TeamCity is supported |
| instanceType | String | The instance type required for the job. ex: c4.xlarge
| ci_parameters | Array | Name/value pairs. These are parameters provided to the CI job. Important to be lower case for TeamCity to recognize it.

Example
```
{
    "job_id": "BrowserClientsQa_TwilightAutomation_RegressionTests",
    "platform": "teamcity",
    "ci_parameters": [
      {"name":"env.BROWSER_NAME","value":"chrome"},
      {"name":"env.MAX_INSTANCES","value":"1"}
    ]
  }
```
