job {
  name 'browser-grid-tc-trigger'
  description('Used to trigger TeamCity Test Builds for Browser Grid Integration Tests')
  concurrentBuild(false)
  blockOnDownstreamProjects() // do not allow this to run if the change instance type downstream job is running

  parameters {
    choiceParam('LOG_LEVEL', ['info', 'debug', 'warn', 'error', 'fatal'], 'The lowest level to display logs to stdout')
    booleanParam('TRIGGER_PERFORMANCE_TESTS', false, 'Whether to test performance tests as well')
  }

  scm {
    git {
      remote {
        github 'qe/ci_trigger', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
      branch 'origin/master'
    }
  }

  logRotator {
    daysToKeep(90)
  }

  wrappers {
    colorizeOutput(colorMap = 'xterm')
    credentialsBinding {
      usernamePassword('TC_USERNAME', 'TC_PASSWORD', 'grid-teamcity-api')
    }
    timestamps()
  }

  steps {
    // Run c4.xlarge tests
    shell """
      set +x
      export TC_USERNAME=\$TC_USERNAME
      export TC_PASSWORD=\$TC_PASSWORD
      set -x
      
      export LOG_LEVEL=\$LOG_LEVEL
      GRID_TARGET_INSTANCE_TYPE="c4.xlarge" make run
    """

    conditionalSteps {
      condition {
        stringsMatch("\$TRIGGER_PERFORMANCE_TESTS", 'true', true)
      }
      steps {
        // Trigger job to change the fleet to c4.2xlarge
        // ex: https://jenkinsci.github.io/job-dsl-plugin/#method/javaposse.jobdsl.dsl.helpers.step.MultiJobStepContext.downstreamParameterized
        downstreamParameterized {
          trigger('browser-grid-win10-modify-instance-type') {
            block {
              buildStepFailure('FAILURE')
              failure('FAILURE')
              unstable('UNSTABLE')
            }

            parameters {
              predefinedProp('GRID_CLUSTER_ID', '2z9oaf6z')
              predefinedProp('GRID_ENVIRONMENT', 'dev')
              predefinedProp('GRID_HUB_ENVIRONMENT', 'dev-ato')
              predefinedProp('GRID_TARGET_INSTANCE_TYPE', 'c4.2xlarge')
              predefinedProp('AWS_DEFAULT_REGION', 'us-west-2')
            }
          }
        }

        // Run c4.2xlarge tests
        shell """
          set +x
          export TC_USERNAME=\$TC_USERNAME
          export TC_PASSWORD=\$TC_PASSWORD
          set -x
          
          export LOG_LEVEL=\$LOG_LEVEL
          GRID_TARGET_INSTANCE_TYPE="c4.2xlarge" make run
        """
      }
    }
  }

  publishers {
    downstreamParameterized {
      trigger('browser-grid-win10-modify-instance-type') {
        condition('ALWAYS')
        parameters {
          predefinedProp('GRID_CLUSTER_ID', '2z9oaf6z')
          predefinedProp('GRID_ENVIRONMENT', 'dev')
          predefinedProp('GRID_HUB_ENVIRONMENT', 'dev-ato')
          predefinedProp('GRID_TARGET_INSTANCE_TYPE', 'c4.xlarge')
          predefinedProp('AWS_DEFAULT_REGION', 'us-west-2')
        }
      }
    }
  }
}

/*
  This job will simply trigger the browser-grid-tc-trigger 5 times. Eventually we'd like to make it configurable via a variable
  The reasoning is if we're doing a browser upgrade or something where we want to run tests many times to ensure no issues
*/
job {
  name 'browser-grid-tc-trigger-multi'
  description('Triggers Browser Grid Integration Tests Multiple Times')
  concurrentBuild(false)

  parameters {
    choiceParam('LOG_LEVEL', ['info', 'debug', 'warn', 'error', 'fatal'], 'The lowest level to display logs to stdout')
    booleanParam('TRIGGER_PERFORMANCE_TESTS', false, 'Whether to test performance tests as well')
  }

  scm {
    git {
      remote {
        github 'qe/ci_trigger', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
      branch 'origin/master'
    }
  }

  logRotator {
    daysToKeep(30)
  }

  steps {
    for (int i = 0; i < 5; i++) {
      downstreamParameterized {
        trigger('browser-grid-tc-trigger') {
          block {
            buildStepFailure('never') // allow later triggers to keep happening so we can get a better idea of results
            failure('FAILURE') // still mark the build as failure
            unstable('UNSTABLE')
          }

          parameters {
            predefinedProp('LOG_LEVEL', "\$LOG_LEVEL")
            predefinedProp('TRIGGER_PERFORMANCE_TESTS', "\$TRIGGER_PERFORMANCE_TESTS")
          }
        }
      }
    }
  }
}
