package main

import (
	"code.justin.tv/qe/ci_trigger/config"
	"code.justin.tv/qe/ci_trigger/teamcity"
	"io/ioutil"
	"log"
	"time"
)

func main() {
	const (
		jobManifestFile = "config.json" // the file to load which holds the jobs to run
		tcHost = "teamcity.xarth.tv" // the teamcity host
		pollDuration = time.Second * 10 // how often to poll the teamcity api for updates
		timeout = time.Minute * 45 // how long per EACH job to wait for it to complete
	)

	// Create Configs
	appConfig, tcConfig := getConfigs()

	appConfig.Logger.Infof("Loading jobs from %s", jobManifestFile)
	data, err := ioutil.ReadFile(jobManifestFile)
	if err != nil {
		appConfig.Logger.Fatalf("error loading job manifest file: %v", err)
	}

	manifest, err := config.NewJobManifest(data, appConfig)
	if err != nil {
		appConfig.Logger.Fatalf("error loading job manifest: %v", err)
	}

	appConfig.Logger.Infof("Configuring TeamCity Client")
	tcClient, err := teamcity.New(tcHost, tcConfig, "latest")
	if err != nil {
		appConfig.Logger.Fatalf("Encountered error creating teamcity client: %v", err)
	}

	appConfig.Logger.Infoln("Running jobs")
	err = RunJobs(appConfig, manifest, tcClient, appConfig.TargetInstanceType, pollDuration, timeout)
	PrintResults(manifest) // do before error check to make sure we always print results
	if err != nil {
		appConfig.Logger.Fatalf("encountered error running jobs: %v", err) // exits 1 if there was a problem running a job
	}
}

// Creates configs needed for main. Logs and exits a fatal error if there's a problem
func getConfigs() (*config.App, *teamcity.Config) {
	appConfig, err := config.NewAppConfig()
	if err != nil {
		log.Fatalf("when creating app config, encountered error: %v", err)
	}
	tcConfig, err := teamcity.NewConfig(appConfig.Logger)
	if err != nil {
		log.Fatalf("when creating teamcity config, encountered error: %v", err)
	}

	return appConfig, tcConfig
}
