# Refer to twitch_web_dev to be able to get things like the security_groups
data "terraform_remote_state" "twitch_web_dev" {
  backend = "s3"
  config {
    bucket = "twitch-web-dev"
    key = "tfstate/web/terraform/v0.7/accounts/twitch-web-dev"
  }
}

resource "aws_instance" "codecov" {
  ami = "ami-af17decf"
  instance_type = "c4.xlarge"
  iam_instance_profile = "qe-prod-codecov"

  root_block_device {
    volume_size = "32"
  }

  # Security/Subnet Groups for internal access only
  vpc_security_group_ids = ["${data.terraform_remote_state.twitch_web_dev.twitch_subnets_sg}"]
  subnet_id = "${data.terraform_remote_state.twitch_web_dev.service_a}"

  tags {
    Name = "qe-codecov"
    Owner = "gribilly"
    Team = "CAPE/QE"
  }
}

output "private_ip" {
  value = "${aws_instance.codecov.private_ip}"
}
