# Initial Variable Declaration
variable "role_name" {
  default = "qe-prod-codecov"
}

variable "policy_name" {
  default = "qe-prod-codecov"
}

variable "core_account" {
  default = "734326455073"
}

# Sandstorm Policy Templates.
# Refer to https://git-aws.internal.justin.tv/systems/sandstorm-agent/blob/master/docs/terraform.md

resource "template_file" "ec2-assume" {
  template = "${file("templates/ec2_sts_assumerole.tmpl")}"
}

resource "template_file" "sandstorm-policy" {
  template = "${file("templates/sandstorm_local_role_policy.tmpl")}"
  vars {
    arn = "arn:aws:iam::${var.core_account}:role/sandstorm/production/templated/role/${var.role_name}"
  }
}

# IAM Role Creation

# Sandstorm Role
resource "aws_iam_role" "codecov-sandstorm-role" {
  name = "${var.role_name}"
  assume_role_policy = "${template_file.ec2-assume.rendered}"
}

output "role-arn" {
  value = "${aws_iam_role.codecov-sandstorm-role.arn}"
}

resource "aws_iam_role_policy" "codecov-sandstorm-policy" {
  name = "${var.policy_name}"
  role = "${aws_iam_role.codecov-sandstorm-role.id}"
  policy = "${template_file.sandstorm-policy.rendered}"
}


# Instance Profile for the qa-prod-codecov role for EC2 instances to assume

resource "aws_iam_instance_profile" "sandstorm_codecov_instance_profile" {
  name = "qe-prod-codecov"
  roles = ["${aws_iam_role.codecov-sandstorm-role.name}"]
}

# Sandstorm Bucket
resource "template_file" "s3-sandstorm-bucket-policy" {
  template = "${file("templates/access_s3_bucket.tmpl")}"
  vars {
    arn = "arn:aws:s3:::twitch-sandstorm/sandstorm-agent.rpm"
  }
}

resource "aws_iam_role_policy" "s3-sandstorm-bucket-policy" {
  name = "SandstormS3BucketAccess"
  role = "${aws_iam_role.codecov-sandstorm-role.id}"
  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
      {
        "Sid": "Stmt1473817796000",
        "Effect": "Allow",
        "Action": [
            "s3:GetObject"
        ],
        "Resource": [
            "arn:aws:s3:::twitch-sandstorm/sandstorm-agent.rpm"
        ]
      }
    ]
}
EOF
}

output "id" {
  value = "${aws_iam_instance_profile.sandstorm_codecov_instance_profile.id}"
}
