data "terraform_remote_state" "vpc_state" {
  backend = "s3"

  config {
    profile = "twitch-cape-qe-aws"
    bucket  = "tf-state-qe"
    key     = "tfstate/qe/terraform/vpc"
    region  = "us-west-2"
  }
}

# Variables for EC2
variable "ami" {
  default = "ami-3e580846"
}

variable "instance_type" {
  default = "c4.2xlarge"
}

variable "volume_size" {
  default = "64"
}

variable "ssl_certificate_id" {
  default = "arn:aws:acm:us-west-2:425992774280:certificate/371d1127-53fd-4c5f-bc34-3d5524a03ed5"
}

# Variables for Private Link
variable "account_id" {
  type        = "string"
  default     = "425992774280"
  description = "AWS account the PrivateLink should be setup."
}

variable "aws_region" {
  type        = "string"
  default     = "us-west-2"
  description = "AWS region the PrivateLink should be setup."
}

variable "app_name" {
  type        = "string"
  default     = "codecov"
  description = "Application name to create the PrivateLink setup."
}

variable "environment" {
  type        = "string"
  default     = "prod"
  description = "Environment PrivateLink setup is for."
}

variable "internal_alb_dns_name" {
  type        = "string"
  default     = "internal-codecov-prod-elb-856519592.us-west-2.elb.amazonaws.com"
  description = "DNS name for the load balancer."
}

# vpc ID for twitch-cape-qe-aws
variable "vpc" {
  type        = "string"
  default     = "vpc-25d89842"
  description = "VPC the PrivateLink should be setup."
}

# subnet ID for Private - A
variable "subnet_a" {
  type        = "string"
  default     = "subnet-cf9a03a8"
  description = "First subnet the PrivateLink should be setup"
}