// Reference: https://github.com/datawire/tf-sns-pagerduty/blob/master/main.tf
resource "aws_sns_topic" "qe_codecov_service_pagerduty" {
  name = "qe-codecov-service-pagerduty"
  display_name = "qe-codecov-service-pagerduty"
}

resource "aws_sns_topic_subscription" "pagerduty" {
  // Reference: https://twitchoncall.pagerduty.com/services/PXG23TY/integrations/PX2NXE4
  endpoint = "https://events.pagerduty.com/integration/d1899bcbb6664d518ea30ee754db11fe/enqueue"
  endpoint_auto_confirms = true
  protocol = "https"
  topic_arn = "${aws_sns_topic.qe_codecov_service_pagerduty.arn}"
}
