variable "codecov_db_password" {} # IMPORTANT: Set with export TF_VAR_codecov_db_password=... or enter when prompted by terraform

resource "aws_db_instance" "codecov_rds_db" {
  engine                 = "postgres"
  engine_version         = "9.3.19"
  instance_class         = "db.t2.medium"
  username               = "postgres"
  password               = "${var.codecov_db_password}"
  db_subnet_group_name   = "main"
  parameter_group_name   = "default.postgres9.3"
  allocated_storage      = 32
  vpc_security_group_ids = ["${aws_security_group.codecov_rds_security_group.id}"]
  backup_window          = "09:00-10:00"

  tags {
    Name  = "codecov-RDS"
    Owner = "anubhaws"
    Team  = "qe"
  }
}

resource "aws_security_group" "codecov_rds_security_group" {
  name        = "codecov_rds_security_group"
  description = "Codecov DB Connection"
  vpc_id      = "vpc-25d89842"

  ingress {
    from_port   = 5432
    to_port     = 5432
    protocol    = "tcp"
    cidr_blocks = []
    self        = true
  }

  ingress {
    from_port   = 5432
    to_port     = 5432
    protocol    = "tcp"
    cidr_blocks = ["${data.terraform_remote_state.parent_account_sgs.twitch_subnets}"]
  }

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }

  tags {
    Name  = "Codecov RDS"
    Owner = "anubhaws"
    Team  = "qe"
  }
}
