resource "aws_elasticache_replication_group" "redis" {
  replication_group_id          = "codecov-redis"
  replication_group_description = "Redis replication cluster"
  node_type                     = "cache.m3.large"
  number_cache_clusters         = "2"
  port                          = 6379
  security_group_ids            = ["${aws_security_group.redis_security_group.id}"]
  parameter_group_name          = "default.redis3.2"
  subnet_group_name             = "${aws_elasticache_subnet_group.codecov_subnet.name}"
  engine_version                = "3.2.4"
  automatic_failover_enabled    = true
  availability_zones            = ["us-west-2a", "us-west-2b"]
  maintenance_window            = "sun:09:00-sun:10:00"

  tags {
    Name  = "codecov-Redis"
    Owner = "anubhaws"
    Team  = "qe"
  }
}

resource "aws_elasticache_subnet_group" "codecov_subnet" {
  name = "codecov-elasticache-subnet"
  description = "Codecov Redis Elasticache Subnet"
  subnet_ids = ["${data.terraform_remote_state.vpc.private_a}","${data.terraform_remote_state.vpc.private_b}","${data.terraform_remote_state.vpc.private_c}"]
}

resource "aws_security_group" "redis_security_group" {
  name        = "codecov_redis_security_group"
  description = "Codecov Redis Security Group"
  vpc_id      = "vpc-25d89842"

  ingress {
    from_port       = 6379
    to_port         = 6379
    protocol        = "tcp"
    cidr_blocks     = ["${data.terraform_remote_state.parent_account_sgs.twitch_subnets}"]
  }

  tags {
    Name  = "Codecov RDS"
    Owner = "anubhaws"
    Team  = "qe"
  }
}
