// Common variables and data go in here

variable "codecov_aws_profile" {
  default = "twitch-cape-qe-aws"
}

variable "codecov_aws_region" {
  default = "us-west-2"
}

variable "qe_tf_state_bucket_name" {
  default = "tf-state-qe"
}

// Used for gathering Internal CIDRs
data "terraform_remote_state" "parent_account_sgs" {
  backend = "s3"

  config {
    profile = "${var.codecov_aws_profile}"
    bucket  = "${var.qe_tf_state_bucket_name}"
    key     = "tfstate/qe/terraform/security-groups"
    region  = "${var.codecov_aws_region}"
  }
}

// Used to get subnet information
data "terraform_remote_state" "vpc" {
  backend = "s3"

  config {
    profile = "${var.codecov_aws_profile}"
    bucket  = "${var.qe_tf_state_bucket_name}"
    key     = "tfstate/qe/terraform/vpc"
    region  = "${var.codecov_aws_region}"
  }
}
