# contacts-service

# overview
```
      HRBI
       | 
 (pull every 3 hrs)
       |
       v
 Twitch-HR --(push)--> LDAP
      |                  |
   (pull attrs)    (pull ldap CN)
      |                  |
      v                  v
 Contacts-Service Import Job
              |
              |
              v
      Contacts-Service DB
              |
              |
              v
       Contacts Service 
```

# project creation
These commands were run to create this repo based on the reference steps at https://git-aws.internal.justin.tv/dta/tcs/tree/989666cc3d1b3c4e6b20e5a8c94cc7f8629d0de6/code_labs/getting_started
* tcs init qe/contacts-service $GOPATH/qe/contacts-service
* tcs skeleton install dta/go-single-server-skeleton@master
* tcs skeleton install --data dta-docker-eb-tf-skeleton.yaml dta/docker-eb-tf-skeleton@master
* tcs checkpoint ./scripts/bootstrap-app.d twitch-cape-qe-aws

# one-time setup toolchain
* brew install protobuf
* go get github.com/golang/protobuf/protoc-gen-go
* go get github.com/twitchtv/twirp/protoc-gen-twirp

# local build
* install deps: glide install
* generate protubuf and twirp code: protoc --proto_path=. --twirp_out=. --go_out=. ./rpc/contacts/*proto
* build ingest too: go build bin/ingest.go
* build server: go build cmd/contacts/main.go

# manta build
* manta -v -f build.json

# import ldap data into db
* export CONTACTS_DB_URL=contacts:password@tcp(localhost:3306)/contacts?charset=utf8&parseTime=true
* ./ingest
 
# run server
* export CONTACTS_DB_URL=contacts:password@tcp(localhost:3306)/contacts?charset=utf8&parseTime=true
* ./main

# run tests
* go test -v tests/contacts_test.go

