package main

import (
	"testing"
	"github.com/nimajalali/go-force/force"
	"code.justin.tv/qe/contacts-service/model/idm"
)

func TestSalesforce(t *testing.T) {
	forceApi, err := getForce()
	if err != nil {
		t.Fatalf(err.Error())
	}

	contactDesc, err := forceApi.DescribeSObject(&idm.Contact{})
	if err != nil {
		t.Fatalf(err.Error())
	}

	contacts := &idm.ContactQueryResponse{}
	err = forceApi.QueryAll(force.BuildQuery(contactDesc.AllFields, "Contact", nil), contacts)
	if err != nil {
		t.Fatalf(err.Error())
	}
	t.Logf("total records=%d", len(contacts.Records))

	for _, c := range contacts.Records {
		//t.Log(c.Name, c.Id, c.Title, c.Email, c.BuildingId, c.Class, c.DepartmentId, c.EmployeeId, c.Firstname, c.Lastname)
		t.Log(c.Name, c.DepartmentId)
	}

	// departments
	deptDesc, err := forceApi.DescribeSObject(&idm.Department{})
	if err != nil {
		t.Fatalf(err.Error())
	}
	depts := &idm.DepartmentQueryResponse{}
	err = forceApi.QueryAll(force.BuildQuery(deptDesc.AllFields, "Department__c", nil), depts)
	if err != nil {
		t.Fatalf(err.Error())
	}
	t.Logf("total records=%d", len(depts.Records))
	for _, d := range depts.Records {
		t.Log(d.Id, d.CuratedName, d.BusinessUnit)
	}


	buDesc, err := forceApi.DescribeSObject(&idm.BusinessUnit{})
	if err != nil {
		t.Fatalf(err.Error())
	}
	bus := &idm.BusinessUnitQueryResponse{}
	err = forceApi.QueryAll(force.BuildQuery(buDesc.AllFields, "BusinessUnit__c", nil), depts)
	if err != nil {
		t.Fatalf(err.Error())
	}
	t.Logf("total records=%d", len(depts.Records))
	for _, b := range bus.Records {
		t.Log(b.Id, b.CuratedName, b.OrganizationId)
	}


	orgDesc, err := forceApi.DescribeSObject(&idm.Organization{})
	if err != nil {
		t.Fatalf(err.Error())
	}
	orgs := &idm.OrganizationQueryResponse{}
	err = forceApi.QueryAll(force.BuildQuery(orgDesc.AllFields, "Organization__c", nil), orgs)
	if err != nil {
		t.Fatalf(err.Error())
	}
	t.Logf("total records=%d", len(orgs.Records))

	for _, o := range orgs.Records {
		t.Log(o.Id, o.CuratedName)
	}


}

func TestIngest(t *testing.T) {
	err := ingest()
	if err != nil {
		t.Fatalf(err.Error())
	}
}

func TestDump(t *testing.T) {
	err := dump()
	if err != nil {
		t.Fatalf(err.Error())
	}
}