package main

import (
	cs "code.justin.tv/qe/contacts-service/internal/contactsserver"
	"code.justin.tv/qe/contacts-service/rpc/contacts"
	"github.com/jinzhu/gorm"
	_ "github.com/jinzhu/gorm/dialects/postgres"
	"log"
	"net/http"
	"os"
)

func main() {
	dbUrl := os.Getenv("CONTACTS_DB_URL")
	if dbUrl == "" {
		ss, err := cs.SetupSandstorm()
		if err != nil {
			log.Fatalf("exiting because CONTACTS_DB_URL env var is unset and sandstorm init failed due to %s", err)
		}
		env := os.Getenv("ENVIRONMENT")
		dbUrl = cs.GetSecrets(ss,"qa-eng/contacts-service/" + env + "/db_url")
	}
	db, err := gorm.Open("postgres", dbUrl)
	if err != nil {
		log.Fatalf("Could not connect to database at %s due to: %s", dbUrl, err.Error())
	}
	defer db.Close()
	db.SingularTable(true)

	server := &cs.Server{DB: db}
	twirpHandler := contacts.NewContactsServer(server, nil)
	http.ListenAndServe(":8000", twirpHandler)
}
