job {
    name 'qe-contacts-service'
    using 'TEMPLATE-autobuild'
    concurrentBuild true

    scm {
        git {
            remote {
                github 'qe/contacts-service', 'ssh', 'git-aws.internal.justin.tv'
                credentials 'git-aws-read-key'
            }
            clean true
        }
    }

    wrappers {
        sshAgent 'git-aws-read-key'
        preBuildCleanup()
        timestamps()
        credentialsBinding {
            file('COURIERD_PRIVATE_KEY', 'courierd')
            file('AWS_CONFIG_FILE', 'aws_config')
            file('SF_SECRETS_FILE', 'qe-salesforce-secrets')
            file('AWS_UPLOADER_CONFIG_FILE', 'twitch-cape-qe-aws-profile')
        }
    }

    steps {
        shell('rm -rf .manta/')
        shell './scripts/docker_build.sh'
    }

    publishers {
        reportQuality('qe/contacts-service', '.manta')
    }
}


