package idm

import "github.com/nimajalali/go-force/sobjects"

type BusinessUnit struct {
	sobjects.BaseSObject
	Id             string                           // salesforce-side id
	Name           string                           // raw LDAP name
	CuratedName    string `force:"Name__c"`         // curated name
	OrganizationId string `force:"Organization__c"` // salesforce-side id
	isDeleted      bool
}

func (t *BusinessUnit) ApiName() string {
	return "BusinessUnit__c"
}

type BusinessUnitQueryResponse struct {
	sobjects.BaseQuery
	Records []BusinessUnit `json:"Records" force:"records"`
}
