package idm

import "github.com/nimajalali/go-force/sobjects"

type Contact struct {
	sobjects.BaseSObject
	SalesforceId     string `force:"Id"`                // salesforce-side id
	EmployeeId       string `force:"EmployeeId__c"`     // amazon-side id
	AmazonUsername   string `force:"AmazonUsername__c"` // amazon-side id
	Name             string
	PreferredName    string `force:"PreferredName__c"`
	Firstname        string
	Lastname         string
	Class            string `force:"Class__c"`
	Title            string
	Email            string
	ReportsToId      string                                 // salesforce-side id
	ParentEmployeeId string `force:"Parent_Employee_Id__c"` // amazon-side id
	DepartmentId     string `force:"Department__c"`         // salesforce-side id
	BuildingId       string `force:"Building__c"`           // salesforce-side id
	RegionId         string `force:"Region__c"`             // salesforce-side id
	isDeleted        bool
}

func (t *Contact) ApiName() string {
	return "Contact"
}

type ContactQueryResponse struct {
	sobjects.BaseQuery
	Records []Contact `json:"Records" force:"records"`
}
