package idm

import "github.com/nimajalali/go-force/sobjects"

type Department struct {
	sobjects.BaseSObject
	Id           string                           // salesforce-side id
	DepartmentId string `force:"DepartmentId__c"` // salesforce-side id
	Name         string                           // raw name from LDAP
	CuratedName  string `force:"Name__c"`
	ShortName    string `force:"Name_Short__c"`
	BusinessUnit string `force:"BusinessUnit__c"` // salesforce-side id
}

func (t *Department) ApiName() string {
	return "Department__c"
}

type DepartmentQueryResponse struct {
	sobjects.BaseQuery
	Records []Department `json:"Records" force:"records"`
}
