package idm

import "github.com/nimajalali/go-force/sobjects"

type Organization struct {
	sobjects.BaseSObject
	Id          string                    // salesforce-side id
	Name        string                    // raw LDAP from name
	CuratedName string `force:"Name__c" ` // curated name
	isDeleted   bool
}

func (t *Organization) ApiName() string {
	return "Organization__c"
}

type OrganizationQueryResponse struct {
	sobjects.BaseQuery
	Records []Organization `json:"Records" force:"records"`
}
