// Code generated by protoc-gen-twirp v5.3.0, DO NOT EDIT.
// source: rpc/contacts/service.proto

/*
Package contacts is a generated twirp stub package.
This code was generated with github.com/twitchtv/twirp/protoc-gen-twirp v5.3.0.

It is generated from these files:
	rpc/contacts/service.proto
*/
package contacts

import bytes "bytes"
import strings "strings"
import context "context"
import fmt "fmt"
import ioutil "io/ioutil"
import http "net/http"

import jsonpb "github.com/golang/protobuf/jsonpb"
import proto "github.com/golang/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Imports only used by utility functions:
import io "io"
import strconv "strconv"
import json "encoding/json"
import url "net/url"

// ==================
// Contacts Interface
// ==================

// Contacts Service returns employee info and org structured, backed by LDAP.
type Contacts interface {
	// GetStructure returns org structure (BU, Org, Team) for the specified user
	GetStructure(context.Context, *UserRequest) (*StructureResponse, error)

	// ListReports returns direct reports of the specified user
	ListReports(context.Context, *GetReportsRequest) (*ReportsResponse, error)

	// GetManager returns manager of the specified user
	GetManager(context.Context, *UserRequest) (*ManagerResponse, error)

	// ListBUs lists all BUs
	ListBUs(context.Context, *BUsRequest) (*BUsResponse, error)

	// ListOrgs lists all Orgs, or Orgs under the optionally specified BU
	ListOrgs(context.Context, *OrgsRequest) (*OrgsResponse, error)

	// ListTeams lists all Orgs, or Orgs under the optionally specified Team
	ListTeams(context.Context, *TeamsRequest) (*TeamsResponse, error)

	// GetPerson returns the specified user
	GetPerson(context.Context, *UserRequest) (*PersonResponse, error)

	// ListPersons returns the all users
	ListPersons(context.Context, *PersonsRequest) (*PersonsResponse, error)
}

// ========================
// Contacts Protobuf Client
// ========================

type contactsProtobufClient struct {
	client HTTPClient
	urls   [8]string
}

// NewContactsProtobufClient creates a Protobuf client that implements the Contacts interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewContactsProtobufClient(addr string, client HTTPClient) Contacts {
	prefix := urlBase(addr) + ContactsPathPrefix
	urls := [8]string{
		prefix + "GetStructure",
		prefix + "ListReports",
		prefix + "GetManager",
		prefix + "ListBUs",
		prefix + "ListOrgs",
		prefix + "ListTeams",
		prefix + "GetPerson",
		prefix + "ListPersons",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &contactsProtobufClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &contactsProtobufClient{
		client: client,
		urls:   urls,
	}
}

func (c *contactsProtobufClient) GetStructure(ctx context.Context, in *UserRequest) (*StructureResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "GetStructure")
	out := new(StructureResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *contactsProtobufClient) ListReports(ctx context.Context, in *GetReportsRequest) (*ReportsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "ListReports")
	out := new(ReportsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *contactsProtobufClient) GetManager(ctx context.Context, in *UserRequest) (*ManagerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "GetManager")
	out := new(ManagerResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *contactsProtobufClient) ListBUs(ctx context.Context, in *BUsRequest) (*BUsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "ListBUs")
	out := new(BUsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *contactsProtobufClient) ListOrgs(ctx context.Context, in *OrgsRequest) (*OrgsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "ListOrgs")
	out := new(OrgsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *contactsProtobufClient) ListTeams(ctx context.Context, in *TeamsRequest) (*TeamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "ListTeams")
	out := new(TeamsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *contactsProtobufClient) GetPerson(ctx context.Context, in *UserRequest) (*PersonResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "GetPerson")
	out := new(PersonResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *contactsProtobufClient) ListPersons(ctx context.Context, in *PersonsRequest) (*PersonsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "ListPersons")
	out := new(PersonsResponse)
	err := doProtobufRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

// ====================
// Contacts JSON Client
// ====================

type contactsJSONClient struct {
	client HTTPClient
	urls   [8]string
}

// NewContactsJSONClient creates a JSON client that implements the Contacts interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewContactsJSONClient(addr string, client HTTPClient) Contacts {
	prefix := urlBase(addr) + ContactsPathPrefix
	urls := [8]string{
		prefix + "GetStructure",
		prefix + "ListReports",
		prefix + "GetManager",
		prefix + "ListBUs",
		prefix + "ListOrgs",
		prefix + "ListTeams",
		prefix + "GetPerson",
		prefix + "ListPersons",
	}
	if httpClient, ok := client.(*http.Client); ok {
		return &contactsJSONClient{
			client: withoutRedirects(httpClient),
			urls:   urls,
		}
	}
	return &contactsJSONClient{
		client: client,
		urls:   urls,
	}
}

func (c *contactsJSONClient) GetStructure(ctx context.Context, in *UserRequest) (*StructureResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "GetStructure")
	out := new(StructureResponse)
	err := doJSONRequest(ctx, c.client, c.urls[0], in, out)
	return out, err
}

func (c *contactsJSONClient) ListReports(ctx context.Context, in *GetReportsRequest) (*ReportsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "ListReports")
	out := new(ReportsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[1], in, out)
	return out, err
}

func (c *contactsJSONClient) GetManager(ctx context.Context, in *UserRequest) (*ManagerResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "GetManager")
	out := new(ManagerResponse)
	err := doJSONRequest(ctx, c.client, c.urls[2], in, out)
	return out, err
}

func (c *contactsJSONClient) ListBUs(ctx context.Context, in *BUsRequest) (*BUsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "ListBUs")
	out := new(BUsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[3], in, out)
	return out, err
}

func (c *contactsJSONClient) ListOrgs(ctx context.Context, in *OrgsRequest) (*OrgsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "ListOrgs")
	out := new(OrgsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[4], in, out)
	return out, err
}

func (c *contactsJSONClient) ListTeams(ctx context.Context, in *TeamsRequest) (*TeamsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "ListTeams")
	out := new(TeamsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[5], in, out)
	return out, err
}

func (c *contactsJSONClient) GetPerson(ctx context.Context, in *UserRequest) (*PersonResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "GetPerson")
	out := new(PersonResponse)
	err := doJSONRequest(ctx, c.client, c.urls[6], in, out)
	return out, err
}

func (c *contactsJSONClient) ListPersons(ctx context.Context, in *PersonsRequest) (*PersonsResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithMethodName(ctx, "ListPersons")
	out := new(PersonsResponse)
	err := doJSONRequest(ctx, c.client, c.urls[7], in, out)
	return out, err
}

// =======================
// Contacts Server Handler
// =======================

type contactsServer struct {
	Contacts
	hooks *twirp.ServerHooks
}

func NewContactsServer(svc Contacts, hooks *twirp.ServerHooks) TwirpServer {
	return &contactsServer{
		Contacts: svc,
		hooks:    hooks,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *contactsServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// ContactsPathPrefix is used for all URL paths on a twirp Contacts server.
// Requests are always: POST ContactsPathPrefix/method
// It can be used in an HTTP mux to route twirp requests along with non-twirp requests on other routes.
const ContactsPathPrefix = "/twirp/twirp.qe.contacts.Contacts/"

func (s *contactsServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "twirp.qe.contacts")
	ctx = ctxsetters.WithServiceName(ctx, "Contacts")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}

	switch req.URL.Path {
	case "/twirp/twirp.qe.contacts.Contacts/GetStructure":
		s.serveGetStructure(ctx, resp, req)
		return
	case "/twirp/twirp.qe.contacts.Contacts/ListReports":
		s.serveListReports(ctx, resp, req)
		return
	case "/twirp/twirp.qe.contacts.Contacts/GetManager":
		s.serveGetManager(ctx, resp, req)
		return
	case "/twirp/twirp.qe.contacts.Contacts/ListBUs":
		s.serveListBUs(ctx, resp, req)
		return
	case "/twirp/twirp.qe.contacts.Contacts/ListOrgs":
		s.serveListOrgs(ctx, resp, req)
		return
	case "/twirp/twirp.qe.contacts.Contacts/ListTeams":
		s.serveListTeams(ctx, resp, req)
		return
	case "/twirp/twirp.qe.contacts.Contacts/GetPerson":
		s.serveGetPerson(ctx, resp, req)
		return
	case "/twirp/twirp.qe.contacts.Contacts/ListPersons":
		s.serveListPersons(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		err = badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, err)
		return
	}
}

func (s *contactsServer) serveGetStructure(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetStructureJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetStructureProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *contactsServer) serveGetStructureJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStructure")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StructureResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetStructure(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StructureResponse and nil error while calling GetStructure. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) serveGetStructureProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetStructure")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *StructureResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetStructure(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *StructureResponse and nil error while calling GetStructure. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) serveListReports(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListReportsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListReportsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *contactsServer) serveListReportsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListReports")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(GetReportsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ReportsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListReports(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ReportsResponse and nil error while calling ListReports. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) serveListReportsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListReports")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(GetReportsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ReportsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListReports(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ReportsResponse and nil error while calling ListReports. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) serveGetManager(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetManagerJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetManagerProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *contactsServer) serveGetManagerJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetManager")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetManager(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerResponse and nil error while calling GetManager. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) serveGetManagerProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetManager")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *ManagerResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetManager(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ManagerResponse and nil error while calling GetManager. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) serveListBUs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListBUsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListBUsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *contactsServer) serveListBUsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListBUs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(BUsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BUsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListBUs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BUsResponse and nil error while calling ListBUs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) serveListBUsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListBUs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(BUsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *BUsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListBUs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *BUsResponse and nil error while calling ListBUs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) serveListOrgs(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListOrgsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListOrgsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *contactsServer) serveListOrgsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListOrgs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(OrgsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OrgsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListOrgs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OrgsResponse and nil error while calling ListOrgs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) serveListOrgsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListOrgs")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(OrgsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *OrgsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListOrgs(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *OrgsResponse and nil error while calling ListOrgs. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) serveListTeams(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListTeamsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListTeamsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *contactsServer) serveListTeamsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListTeams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(TeamsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *TeamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListTeams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TeamsResponse and nil error while calling ListTeams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) serveListTeamsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListTeams")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(TeamsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *TeamsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListTeams(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *TeamsResponse and nil error while calling ListTeams. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) serveGetPerson(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveGetPersonJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveGetPersonProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *contactsServer) serveGetPersonJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPerson")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(UserRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PersonResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPerson(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PersonResponse and nil error while calling GetPerson. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) serveGetPersonProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "GetPerson")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(UserRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PersonResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.GetPerson(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PersonResponse and nil error while calling GetPerson. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) serveListPersons(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListPersonsJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListPersonsProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *contactsServer) serveListPersonsJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPersons")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	reqContent := new(PersonsRequest)
	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(req.Body, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request json")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PersonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListPersons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PersonsResponse and nil error while calling ListPersons. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	var buf bytes.Buffer
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(&buf, respContent); err != nil {
		err = wrapErr(err, "failed to marshal json response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.WriteHeader(http.StatusOK)

	respBytes := buf.Bytes()
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) serveListPersonsProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListPersons")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := ioutil.ReadAll(req.Body)
	if err != nil {
		err = wrapErr(err, "failed to read request body")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}
	reqContent := new(PersonsRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		err = wrapErr(err, "failed to parse request proto")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	// Call service method
	var respContent *PersonsResponse
	func() {
		defer func() {
			// In case of a panic, serve a 500 error and then panic.
			if r := recover(); r != nil {
				s.writeError(ctx, resp, twirp.InternalError("Internal service panic"))
				panic(r)
			}
		}()
		respContent, err = s.ListPersons(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *PersonsResponse and nil error while calling ListPersons. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		err = wrapErr(err, "failed to marshal proto response")
		s.writeError(ctx, resp, twirp.InternalErrorWith(err))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *contactsServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor0, 0
}

func (s *contactsServer) ProtocGenTwirpVersion() string {
	return "v5.3.0"
}

// =====
// Utils
// =====

// HTTPClient is the interface used by generated clients to send HTTP requests.
// It is fulfilled by *(net/http).Client, which is sufficient for most users.
// Users can provide their own implementation for special retry policies.
//
// HTTPClient implementations should not follow redirects. Redirects are
// automatically disabled if *(net/http).Client is passed to client
// constructors. See the withoutRedirects function in this file for more
// details.
type HTTPClient interface {
	Do(req *http.Request) (*http.Response, error)
}

// TwirpServer is the interface generated server structs will support: they're
// HTTP handlers with additional methods for accessing metadata about the
// service. Those accessors are a low-level API for building reflection tools.
// Most people can think of TwirpServers as just http.Handlers.
type TwirpServer interface {
	http.Handler
	// ServiceDescriptor returns gzipped bytes describing the .proto file that
	// this service was generated from. Once unzipped, the bytes can be
	// unmarshalled as a
	// github.com/golang/protobuf/protoc-gen-go/descriptor.FileDescriptorProto.
	//
	// The returned integer is the index of this particular service within that
	// FileDescriptorProto's 'Service' slice of ServiceDescriptorProtos. This is a
	// low-level field, expected to be used for reflection.
	ServiceDescriptor() ([]byte, int)
	// ProtocGenTwirpVersion is the semantic version string of the version of
	// twirp used to generate this file.
	ProtocGenTwirpVersion() string
}

// WriteError writes an HTTP response with a valid Twirp error format.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func WriteError(resp http.ResponseWriter, err error) {
	writeError(context.Background(), resp, err, nil)
}

// writeError writes Twirp errors in the response and triggers hooks.
func writeError(ctx context.Context, resp http.ResponseWriter, err error, hooks *twirp.ServerHooks) {
	// Non-twirp errors are wrapped as Internal (default)
	twerr, ok := err.(twirp.Error)
	if !ok {
		twerr = twirp.InternalErrorWith(err)
	}

	statusCode := twirp.ServerHTTPStatusFromErrorCode(twerr.Code())
	ctx = ctxsetters.WithStatusCode(ctx, statusCode)
	ctx = callError(ctx, hooks, twerr)

	resp.Header().Set("Content-Type", "application/json") // Error responses are always JSON (instead of protobuf)
	resp.WriteHeader(statusCode)                          // HTTP response status code

	respBody := marshalErrorToJSON(twerr)
	_, writeErr := resp.Write(respBody)
	if writeErr != nil {
		// We have three options here. We could log the error, call the Error
		// hook, or just silently ignore the error.
		//
		// Logging is unacceptable because we don't have a user-controlled
		// logger; writing out to stderr without permission is too rude.
		//
		// Calling the Error hook would confuse users: it would mean the Error
		// hook got called twice for one request, which is likely to lead to
		// duplicated log messages and metrics, no matter how well we document
		// the behavior.
		//
		// Silently ignoring the error is our least-bad option. It's highly
		// likely that the connection is broken and the original 'err' says
		// so anyway.
		_ = writeErr
	}

	callResponseSent(ctx, hooks)
}

// urlBase helps ensure that addr specifies a scheme. If it is unparsable
// as a URL, it returns addr unchanged.
func urlBase(addr string) string {
	// If the addr specifies a scheme, use it. If not, default to
	// http. If url.Parse fails on it, return it unchanged.
	url, err := url.Parse(addr)
	if err != nil {
		return addr
	}
	if url.Scheme == "" {
		url.Scheme = "http"
	}
	return url.String()
}

// getCustomHTTPReqHeaders retrieves a copy of any headers that are set in
// a context through the twirp.WithHTTPRequestHeaders function.
// If there are no headers set, or if they have the wrong type, nil is returned.
func getCustomHTTPReqHeaders(ctx context.Context) http.Header {
	header, ok := twirp.HTTPRequestHeaders(ctx)
	if !ok || header == nil {
		return nil
	}
	copied := make(http.Header)
	for k, vv := range header {
		if vv == nil {
			copied[k] = nil
			continue
		}
		copied[k] = make([]string, len(vv))
		copy(copied[k], vv)
	}
	return copied
}

// newRequest makes an http.Request from a client, adding common headers.
func newRequest(ctx context.Context, url string, reqBody io.Reader, contentType string) (*http.Request, error) {
	req, err := http.NewRequest("POST", url, reqBody)
	if err != nil {
		return nil, err
	}
	req = req.WithContext(ctx)
	if customHeader := getCustomHTTPReqHeaders(ctx); customHeader != nil {
		req.Header = customHeader
	}
	req.Header.Set("Accept", contentType)
	req.Header.Set("Content-Type", contentType)
	req.Header.Set("Twirp-Version", "v5.3.0")
	return req, nil
}

// JSON serialization for errors
type twerrJSON struct {
	Code string            `json:"code"`
	Msg  string            `json:"msg"`
	Meta map[string]string `json:"meta,omitempty"`
}

// marshalErrorToJSON returns JSON from a twirp.Error, that can be used as HTTP error response body.
// If serialization fails, it will use a descriptive Internal error instead.
func marshalErrorToJSON(twerr twirp.Error) []byte {
	// make sure that msg is not too large
	msg := twerr.Msg()
	if len(msg) > 1e6 {
		msg = msg[:1e6]
	}

	tj := twerrJSON{
		Code: string(twerr.Code()),
		Msg:  msg,
		Meta: twerr.MetaMap(),
	}

	buf, err := json.Marshal(&tj)
	if err != nil {
		buf = []byte("{\"type\": \"" + twirp.Internal + "\", \"msg\": \"There was an error but it could not be serialized into JSON\"}") // fallback
	}

	return buf
}

// errorFromResponse builds a twirp.Error from a non-200 HTTP response.
// If the response has a valid serialized Twirp error, then it's returned.
// If not, the response status code is used to generate a similar twirp
// error. See twirpErrorFromIntermediary for more info on intermediary errors.
func errorFromResponse(resp *http.Response) twirp.Error {
	statusCode := resp.StatusCode
	statusText := http.StatusText(statusCode)

	if isHTTPRedirect(statusCode) {
		// Unexpected redirect: it must be an error from an intermediary.
		// Twirp clients don't follow redirects automatically, Twirp only handles
		// POST requests, redirects should only happen on GET and HEAD requests.
		location := resp.Header.Get("Location")
		msg := fmt.Sprintf("unexpected HTTP status code %d %q received, Location=%q", statusCode, statusText, location)
		return twirpErrorFromIntermediary(statusCode, msg, location)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read server error response body", err)
	}
	var tj twerrJSON
	if err := json.Unmarshal(respBodyBytes, &tj); err != nil {
		// Invalid JSON response; it must be an error from an intermediary.
		msg := fmt.Sprintf("Error from intermediary with HTTP status code %d %q", statusCode, statusText)
		return twirpErrorFromIntermediary(statusCode, msg, string(respBodyBytes))
	}

	errorCode := twirp.ErrorCode(tj.Code)
	if !twirp.IsValidErrorCode(errorCode) {
		msg := "invalid type returned from server error response: " + tj.Code
		return twirp.InternalError(msg)
	}

	twerr := twirp.NewError(errorCode, tj.Msg)
	for k, v := range tj.Meta {
		twerr = twerr.WithMeta(k, v)
	}
	return twerr
}

// twirpErrorFromIntermediary maps HTTP errors from non-twirp sources to twirp errors.
// The mapping is similar to gRPC: https://github.com/grpc/grpc/blob/master/doc/http-grpc-status-mapping.md.
// Returned twirp Errors have some additional metadata for inspection.
func twirpErrorFromIntermediary(status int, msg string, bodyOrLocation string) twirp.Error {
	var code twirp.ErrorCode
	if isHTTPRedirect(status) { // 3xx
		code = twirp.Internal
	} else {
		switch status {
		case 400: // Bad Request
			code = twirp.Internal
		case 401: // Unauthorized
			code = twirp.Unauthenticated
		case 403: // Forbidden
			code = twirp.PermissionDenied
		case 404: // Not Found
			code = twirp.BadRoute
		case 429, 502, 503, 504: // Too Many Requests, Bad Gateway, Service Unavailable, Gateway Timeout
			code = twirp.Unavailable
		default: // All other codes
			code = twirp.Unknown
		}
	}

	twerr := twirp.NewError(code, msg)
	twerr = twerr.WithMeta("http_error_from_intermediary", "true") // to easily know if this error was from intermediary
	twerr = twerr.WithMeta("status_code", strconv.Itoa(status))
	if isHTTPRedirect(status) {
		twerr = twerr.WithMeta("location", bodyOrLocation)
	} else {
		twerr = twerr.WithMeta("body", bodyOrLocation)
	}
	return twerr
}
func isHTTPRedirect(status int) bool {
	return status >= 300 && status <= 399
}

// wrappedError implements the github.com/pkg/errors.Causer interface, allowing errors to be
// examined for their root cause.
type wrappedError struct {
	msg   string
	cause error
}

func wrapErr(err error, msg string) error { return &wrappedError{msg: msg, cause: err} }
func (e *wrappedError) Cause() error      { return e.cause }
func (e *wrappedError) Error() string     { return e.msg + ": " + e.cause.Error() }

// clientError adds consistency to errors generated in the client
func clientError(desc string, err error) twirp.Error {
	return twirp.InternalErrorWith(wrapErr(err, desc))
}

// badRouteError is used when the twirp server cannot route a request
func badRouteError(msg string, method, url string) twirp.Error {
	err := twirp.NewError(twirp.BadRoute, msg)
	err = err.WithMeta("twirp_invalid_route", method+" "+url)
	return err
}

// The standard library will, by default, redirect requests (including POSTs) if it gets a 302 or
// 303 response, and also 301s in go1.8. It redirects by making a second request, changing the
// method to GET and removing the body. This produces very confusing error messages, so instead we
// set a redirect policy that always errors. This stops Go from executing the redirect.
//
// We have to be a little careful in case the user-provided http.Client has its own CheckRedirect
// policy - if so, we'll run through that policy first.
//
// Because this requires modifying the http.Client, we make a new copy of the client and return it.
func withoutRedirects(in *http.Client) *http.Client {
	copy := *in
	copy.CheckRedirect = func(req *http.Request, via []*http.Request) error {
		if in.CheckRedirect != nil {
			// Run the input's redirect if it exists, in case it has side effects, but ignore any error it
			// returns, since we want to use ErrUseLastResponse.
			err := in.CheckRedirect(req, via)
			_ = err // Silly, but this makes sure generated code passes errcheck -blank, which some people use.
		}
		return http.ErrUseLastResponse
	}
	return &copy
}

// doProtobufRequest is common code to make a request to the remote twirp service.
func doProtobufRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBodyBytes, err := proto.Marshal(in)
	if err != nil {
		return clientError("failed to marshal proto request", err)
	}
	reqBody := bytes.NewBuffer(reqBodyBytes)
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/protobuf")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	respBodyBytes, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return clientError("failed to read response body", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if err = proto.Unmarshal(respBodyBytes, out); err != nil {
		return clientError("failed to unmarshal proto response", err)
	}
	return nil
}

// doJSONRequest is common code to make a request to the remote twirp service.
func doJSONRequest(ctx context.Context, client HTTPClient, url string, in, out proto.Message) (err error) {
	reqBody := bytes.NewBuffer(nil)
	marshaler := &jsonpb.Marshaler{OrigName: true}
	if err = marshaler.Marshal(reqBody, in); err != nil {
		return clientError("failed to marshal json request", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	req, err := newRequest(ctx, url, reqBody, "application/json")
	if err != nil {
		return clientError("could not build request", err)
	}
	resp, err := client.Do(req)
	if err != nil {
		return clientError("failed to do request", err)
	}

	defer func() {
		cerr := resp.Body.Close()
		if err == nil && cerr != nil {
			err = clientError("failed to close response body", cerr)
		}
	}()

	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}

	if resp.StatusCode != 200 {
		return errorFromResponse(resp)
	}

	unmarshaler := jsonpb.Unmarshaler{AllowUnknownFields: true}
	if err = unmarshaler.Unmarshal(resp.Body, out); err != nil {
		return clientError("failed to unmarshal json response", err)
	}
	if err = ctx.Err(); err != nil {
		return clientError("aborted because context was done", err)
	}
	return nil
}

// Call twirp.ServerHooks.RequestReceived if the hook is available
func callRequestReceived(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestReceived == nil {
		return ctx, nil
	}
	return h.RequestReceived(ctx)
}

// Call twirp.ServerHooks.RequestRouted if the hook is available
func callRequestRouted(ctx context.Context, h *twirp.ServerHooks) (context.Context, error) {
	if h == nil || h.RequestRouted == nil {
		return ctx, nil
	}
	return h.RequestRouted(ctx)
}

// Call twirp.ServerHooks.ResponsePrepared if the hook is available
func callResponsePrepared(ctx context.Context, h *twirp.ServerHooks) context.Context {
	if h == nil || h.ResponsePrepared == nil {
		return ctx
	}
	return h.ResponsePrepared(ctx)
}

// Call twirp.ServerHooks.ResponseSent if the hook is available
func callResponseSent(ctx context.Context, h *twirp.ServerHooks) {
	if h == nil || h.ResponseSent == nil {
		return
	}
	h.ResponseSent(ctx)
}

// Call twirp.ServerHooks.Error if the hook is available
func callError(ctx context.Context, h *twirp.ServerHooks, err twirp.Error) context.Context {
	if h == nil || h.Error == nil {
		return ctx
	}
	return h.Error(ctx, err)
}

var twirpFileDescriptor0 = []byte{
	// 876 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x56, 0xeb, 0x8e, 0x1b, 0x35,
	0x14, 0x56, 0xee, 0x33, 0x27, 0x37, 0xd6, 0x14, 0x31, 0x4a, 0xe9, 0x12, 0x4c, 0x29, 0x15, 0x2a,
	0x59, 0xb4, 0x48, 0xa8, 0x12, 0x48, 0xa8, 0xa9, 0xc4, 0x36, 0xda, 0xb2, 0x1b, 0x0d, 0x1b, 0x21,
	0xf1, 0x27, 0x9a, 0x8b, 0x3b, 0xb5, 0x94, 0xb9, 0xd4, 0xe3, 0xa1, 0xda, 0xbe, 0x02, 0x2f, 0xc0,
	0x4f, 0x9e, 0x84, 0x67, 0xab, 0xec, 0xb1, 0x27, 0xd9, 0x64, 0x26, 0x89, 0xda, 0x7f, 0xe3, 0x73,
	0x3e, 0x7f, 0xe7, 0xf3, 0xf1, 0x17, 0x9f, 0xc0, 0x88, 0x25, 0xde, 0x99, 0x17, 0x47, 0xdc, 0xf1,
	0x78, 0x7a, 0x96, 0x12, 0xf6, 0x37, 0xf5, 0xc8, 0x24, 0x61, 0x31, 0x8f, 0xd1, 0x09, 0x7f, 0x4b,
	0x59, 0x32, 0x79, 0x43, 0x26, 0x1a, 0x80, 0x7f, 0x83, 0xee, 0x22, 0x25, 0xcc, 0x26, 0x6f, 0x32,
	0x92, 0x72, 0xf4, 0x39, 0x74, 0xb2, 0x94, 0xb0, 0x25, 0xf5, 0xad, 0xda, 0xb8, 0xf6, 0xd8, 0xb4,
	0xdb, 0x62, 0x39, 0xf3, 0xd1, 0x29, 0x00, 0x09, 0x93, 0x55, 0x7c, 0x4b, 0xc8, 0xcc, 0xb7, 0xea,
	0xe3, 0xda, 0xe3, 0xbe, 0xbd, 0x11, 0xc1, 0xff, 0xd4, 0xe0, 0xe4, 0x82, 0x70, 0x9b, 0x24, 0x31,
	0xe3, 0xe9, 0x41, 0xba, 0x6f, 0x61, 0x48, 0x23, 0x6f, 0x95, 0xf9, 0x64, 0x19, 0x3a, 0x91, 0x13,
	0x10, 0x26, 0x39, 0x0d, 0x7b, 0xa0, 0xc2, 0xbf, 0xe7, 0x51, 0x74, 0x0f, 0x5a, 0x3e, 0x49, 0xf8,
	0x6b, 0xab, 0x21, 0x4b, 0xe6, 0x8b, 0x2d, 0x35, 0xcd, 0x1d, 0x35, 0x4f, 0xa4, 0x18, 0xc5, 0x71,
	0x48, 0x0c, 0xee, 0x01, 0x4c, 0x17, 0x5a, 0x33, 0xc6, 0xd0, 0xbd, 0x66, 0x41, 0x71, 0x84, 0x4f,
	0xa1, 0xe5, 0x66, 0x7a, 0x4f, 0xdf, 0x6e, 0xba, 0xd9, 0xcc, 0xc7, 0xdf, 0x40, 0xef, 0x86, 0x38,
	0x61, 0x01, 0xfa, 0x0c, 0xda, 0x31, 0x0b, 0xd6, 0xa8, 0x56, 0xcc, 0x82, 0x99, 0x8f, 0x3f, 0x81,
	0xc1, 0x9c, 0xb0, 0x34, 0x8e, 0x0a, 0xf2, 0x67, 0xd0, 0x99, 0x8b, 0xab, 0x98, 0x2e, 0xd0, 0x00,
	0xea, 0x05, 0xbe, 0x4e, 0x7d, 0x84, 0xa0, 0x19, 0x39, 0x21, 0x91, 0x7d, 0x30, 0x6d, 0xf9, 0x2d,
	0x62, 0x3e, 0x49, 0x3d, 0x79, 0x78, 0xd3, 0x96, 0xdf, 0x38, 0x02, 0x43, 0x52, 0x5c, 0xb3, 0xe0,
	0x43, 0x39, 0xd0, 0x77, 0x50, 0x77, 0x33, 0xd9, 0xb7, 0xee, 0xf9, 0x68, 0xb2, 0xe3, 0x8a, 0x89,
	0xd2, 0x68, 0xd7, 0xdd, 0x0c, 0x33, 0x30, 0xe5, 0x52, 0x1c, 0xf8, 0x83, 0x0b, 0x7e, 0x0f, 0x8d,
	0x98, 0x05, 0xaa, 0xe2, 0xfd, 0xaa, 0x8a, 0xd7, 0x2c, 0xb0, 0x05, 0x0e, 0xff, 0xdf, 0x80, 0xae,
	0x8c, 0xe4, 0xed, 0xdb, 0x29, 0xbb, 0x71, 0x95, 0xf5, 0x3b, 0xbe, 0xba, 0x07, 0x2d, 0x12, 0x3a,
	0x74, 0xa5, 0x8a, 0xe7, 0x0b, 0xf4, 0x00, 0xe0, 0x15, 0x65, 0x29, 0x5f, 0x4a, 0xad, 0x4d, 0x99,
	0x32, 0x65, 0xe4, 0x4a, 0x08, 0xbe, 0x0f, 0xe6, 0xca, 0xd1, 0xd9, 0x96, 0xcc, 0x1a, 0x22, 0x20,
	0x93, 0x3f, 0x40, 0x93, 0x13, 0x27, 0xb4, 0xda, 0x52, 0xfa, 0x17, 0x55, 0xd2, 0x45, 0x77, 0x6c,
	0x89, 0x44, 0x4f, 0xa1, 0xa3, 0x3d, 0xdd, 0x91, 0x9b, 0x4e, 0xab, 0x36, 0xe5, 0xa7, 0xb3, 0x35,
	0x5c, 0xa8, 0xe7, 0x94, 0xaf, 0x88, 0x65, 0xe4, 0xea, 0xe5, 0x02, 0x3d, 0x82, 0x21, 0x7f, 0x4b,
	0xb9, 0xf7, 0x7a, 0xe9, 0x84, 0xef, 0xa2, 0x65, 0x46, 0x7d, 0xcb, 0x94, 0xf9, 0x7e, 0x1e, 0x7e,
	0x16, 0xbe, 0x8b, 0x16, 0xd4, 0x47, 0xbf, 0x80, 0xb1, 0x8a, 0x3d, 0x87, 0xd3, 0x38, 0xb2, 0x40,
	0x16, 0x1e, 0x57, 0x15, 0x7e, 0xa9, 0x70, 0x76, 0xb1, 0x03, 0x3d, 0x82, 0x81, 0xfe, 0x01, 0x5d,
	0x65, 0xa1, 0x4b, 0x98, 0xd5, 0x95, 0xed, 0xde, 0x8a, 0xa2, 0x87, 0xd0, 0x9f, 0x33, 0xf2, 0x8a,
	0x30, 0x46, 0x7c, 0xd1, 0x20, 0xab, 0x97, 0x6b, 0xb9, 0x13, 0xc4, 0x4c, 0xa0, 0x36, 0x0a, 0xed,
	0xdc, 0xe0, 0xd7, 0xd0, 0x77, 0x33, 0xba, 0xf2, 0x69, 0x14, 0x2c, 0x37, 0x1c, 0xd4, 0xd3, 0x41,
	0xd9, 0x7b, 0x0b, 0x3a, 0x5e, 0x9c, 0x45, 0x9c, 0xdd, 0xaa, 0xfb, 0xd4, 0x4b, 0xe1, 0x31, 0x8f,
	0xf2, 0x5b, 0x75, 0x97, 0xf2, 0x1b, 0xff, 0x57, 0x83, 0x93, 0x3f, 0x38, 0xcb, 0x3c, 0x9e, 0x31,
	0x62, 0x93, 0x34, 0x89, 0xa3, 0x94, 0x28, 0xab, 0xd7, 0x8e, 0xb1, 0xba, 0x76, 0x69, 0xfd, 0x38,
	0x97, 0x16, 0xd6, 0x68, 0x1c, 0x6b, 0x0d, 0x7c, 0x09, 0xc3, 0xe2, 0x85, 0x54, 0xfa, 0x9e, 0x42,
	0x27, 0xc9, 0xdf, 0x08, 0xab, 0x36, 0x6e, 0x1c, 0xe3, 0x16, 0x05, 0xc7, 0x33, 0x18, 0x16, 0x2f,
	0x9c, 0x22, 0xfb, 0x09, 0xda, 0x79, 0x56, 0x1d, 0xf8, 0x10, 0x97, 0x42, 0xe3, 0x9f, 0xa1, 0x2b,
	0x5f, 0x40, 0x45, 0xf3, 0x04, 0x1a, 0x6e, 0xa6, 0xf5, 0xec, 0x6b, 0x9a, 0x80, 0xe1, 0x5f, 0xa1,
	0x97, 0x3f, 0x98, 0x6a, 0xf7, 0x19, 0x34, 0x63, 0x16, 0xe8, 0xed, 0x7b, 0xdb, 0x28, 0x81, 0xf8,
	0x39, 0xf4, 0xd5, 0x6b, 0xaa, 0x18, 0xce, 0xa1, 0x25, 0xda, 0xa5, 0x29, 0xf6, 0x77, 0x36, 0x87,
	0xe2, 0x17, 0xfa, 0xad, 0xfd, 0xe8, 0x66, 0x5c, 0xc2, 0xb0, 0x78, 0xb5, 0x3f, 0xf6, 0x92, 0xce,
	0xff, 0x6d, 0x81, 0xf1, 0x5c, 0x21, 0xd0, 0x0d, 0xf4, 0x2e, 0x08, 0x2f, 0x3c, 0x8a, 0xca, 0x58,
	0x36, 0xa6, 0xf1, 0xe8, 0x61, 0x49, 0x7e, 0xd7, 0xe1, 0x7f, 0x42, 0xf7, 0x25, 0x4d, 0xf5, 0xe8,
	0x45, 0x65, 0x9b, 0x76, 0x26, 0xf3, 0x08, 0x97, 0xa0, 0xb6, 0xad, 0x39, 0x07, 0x58, 0x4f, 0xd1,
	0x83, 0x62, 0xcb, 0x18, 0xb7, 0xfd, 0xf9, 0x02, 0x3a, 0x42, 0xea, 0x74, 0x91, 0xa2, 0x07, 0x25,
	0xf0, 0xf5, 0x14, 0x1e, 0x9d, 0x56, 0xa5, 0x15, 0xd3, 0x25, 0x18, 0x82, 0x49, 0x18, 0xaf, 0x54,
	0xd9, 0xc6, 0x08, 0x1f, 0x7d, 0x59, 0x99, 0x57, 0x64, 0x57, 0x60, 0x0a, 0x32, 0x69, 0x42, 0x54,
	0x86, 0xde, 0x1c, 0xf6, 0xa3, 0x71, 0x35, 0x60, 0xcd, 0x77, 0x41, 0xb8, 0x9a, 0x5d, 0x87, 0xfa,
	0xf6, 0x55, 0x99, 0x95, 0xee, 0x3a, 0xf9, 0x26, 0xbf, 0x61, 0xe5, 0x4a, 0x54, 0xbd, 0x63, 0xef,
	0xf5, 0x6e, 0x99, 0x7a, 0x0a, 0x7f, 0x19, 0x3a, 0xe7, 0xb6, 0xe5, 0x1f, 0xc4, 0x1f, 0xdf, 0x07,
	0x00, 0x00, 0xff, 0xff, 0xed, 0xf5, 0x13, 0x6d, 0x3e, 0x0a, 0x00, 0x00,
}
