// data store alarms
resource "aws_cloudwatch_metric_alarm" "rds_connections" {
  // meta-data
  alarm_name = "qe-contacts-service-rds-connections-alarm"
  alarm_description = "monitors db connections"

  // filter the metrics into this alarm
  namespace = "AWS/RDS"
  metric_name = "DatabaseConnections"
  dimensions {
    DBInstanceIdentifier = "qe-contacts-production"
  }

  // setup the thresholds for the metric
  statistic = "Maximum"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  threshold = "20"
  period = "300"
  // 5 minutes
  evaluation_periods = "1"

  // action - notify the SNS topic that's configured for pagerduty
  alarm_actions = [
    "${aws_sns_topic.qe_contacts_service_service_pagerduty.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "rds_cpu_utilization" {
  // meta-data
  alarm_name = "qe-contacts-service-rds-cpu-utilization-alarm"
  alarm_description = "monitors db cpu utilization"

  // filter the metrics into this alarm
  namespace = "AWS/RDS"
  metric_name = "DatabaseConnections"
  dimensions {
    DBInstanceIdentifier = "qe-contacts-production"
  }

  // setup the thresholds for the metric
  statistic = "Maximum"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  threshold = "20"
  period = "300"
  // 5 minutes
  evaluation_periods = "1"

  // action - notify the SNS topic that's configured for pagerduty
  alarm_actions = [
    "${aws_sns_topic.qe_contacts_service_service_pagerduty.arn}"]
}


// data ingest job alarms
resource "aws_cloudwatch_metric_alarm" "lambda_invocation_errors" {
  // meta-data
  alarm_name = "qe-contacts-service-lambda-ingest-invocation-error-alarm"
  alarm_description = "monitors invocation errors"

  // filter the metrics into this alarm
  namespace = "AWS/Lambda"
  metric_name = "Errors"
  dimensions {
    FunctionName = "contacts_service_ingest-production"
  }

  // setup the thresholds for the metric
  statistic = "Sum"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  threshold = "1"
  period = "300"
  // 5 minutes
  evaluation_periods = "1"

  // action - notify the SNS topic that's configured for pagerduty
  alarm_actions = [
    "${aws_sns_topic.qe_contacts_service_service_pagerduty.arn}"]
}

// service alarms
resource "aws_cloudwatch_metric_alarm" "service_instance_unhealthy" {
  // meta-data
  alarm_name = "qe-contacts-service-docker-in-ec2-unhealthy-alarm"
  alarm_description = "monitors service instance health"

  // filter the metrics into this alarm
  namespace = "AWS/ELB"
  metric_name = "UnHealthyHostCount"
  dimensions {
    LoadBalancerName = "awseb-e-k-AWSEBLoa-D7PRE8YMIDGE"
  }

  // setup the thresholds for the metric
  statistic = "Maximum"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  threshold = "1"
  period = "300"
  // 5 minutes
  evaluation_periods = "1"

  // action - notify the SNS topic that's configured for pagerduty
  alarm_actions = [
    "${aws_sns_topic.qe_contacts_service_service_pagerduty.arn}"]
}