

module "bs-production" {
  source = "../modules/tf_beanstalk_webserver_env"
  aws_profile = "twitch-cape-qe-aws"
  aws_region = "us-west-2"
  eb_application_name = "${module.bs-app-twitch-cape-qe-aws.beanstalk_application_name}"
  vpc_id = "vpc-25d89842"
  ec2_subnet_ids = "subnet-cf9a03a8,subnet-b3b102fa,subnet-c83d2990"
  elb_subnet_ids = "subnet-cf9a03a8,subnet-b3b102fa,subnet-c83d2990"
  elb_loadbalancer_security_groups = "sg-09687471"
  auto_scaling_lc_security_groups = "sg-09687471"
  # to get latest images, run: aws elasticbeanstalk list-available-solution-stacks | grep "running Docker"
  solution_stack_name = "64bit Amazon Linux 2018.03 v2.12.2 running Docker 18.03.1-ce"
  auto_scaling_lc_instance_type = "t2.micro"
  owner = "qe-team@twitch.tv"
  service = "qe/contacts-service"
  env = "production"
  associate_public_address = "false"
  cname_prefix = "contacts-api-prod"

}

resource "aws_cloudwatch_event_rule" "run_daily_contacts_service_production" {
  name = "contacts_service_ingest-production-daily"
  schedule_expression = "cron(0 8 * * ? *)"
}

resource "aws_cloudwatch_event_target" "lambda_event_target_production" {
  rule = "${aws_cloudwatch_event_rule.run_daily_contacts_service_production.name}"
  arn = "${module.lambda-production.arn}"
}

resource "aws_lambda_permission" "allow_cloudwatch_contacts_service_ingest_production" {
  statement_id = "AllowExecutionFromCloudWatch_contacts_service_ingest_production"
  action = "lambda:InvokeFunction"
  function_name = "contacts_service_ingest-production"
  principal = "events.amazonaws.com"
  source_arn = "${aws_cloudwatch_event_rule.run_daily_contacts_service_production.arn}"
}

module "lambda-production" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_lambda_app.git?ref=1.6.0"
  owner = "qe-team"
  repository = "${var.repo}"
  environment = "production"
  principal = "${var.principal}"
  lambda_runtime = "${var.lambda_runtime}"
  aws_profile = "${var.contacts_aws_profile}"
  aws_region = "${var.contacts_aws_region}"
  lambda_vpc_subnet_ids = "${data.terraform_remote_state.parent_account_vpc.private_a},${data.terraform_remote_state.parent_account_vpc.private_b},${data.terraform_remote_state.parent_account_vpc.private_c}"
  lambda_vpc_security_group_ids = "${data.terraform_remote_state.parent_account_vpc.twitch_subnets_sg}"
  lambda_s3_bucket = "${var.lambda_bucket}"
  lambda_policy = "${file("files/lambda_policy-production.json")}"

  lambda_handler = "ingest"
  lambda_function_name = "contacts_service_ingest-production"
  lambda_description = "Ingests data from Twitch-HR Salesforce backend"
  lambda_timeout = "180"
  lambda_memory_size = 128
  lambda_environment_variables = {
    ENVIRONMENT = "production"
  }
}