variable "contacts_db_password" {} # IMPORTANT: Set with export TF_VAR_contacts_db_password=... or enter when prompted by terraform

module "tf_aws_db_instance_staging" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_aws_db_instance.git?ref=master"
  identifier = "qe-contacts-staging"
  aws_profile = "${var.contacts_aws_profile}"
  aws_region = "${var.contacts_aws_region}"
  owner = "qe"
  service = "contacts-service"
  tag_service = "qe/contacts-service"
  tag_owner = "lukemng@justin.tv"
  environment = "staging"
  vpc_id = "${data.terraform_remote_state.parent_account_vpc.vpc_id}"
  engine = "postgres"
  engine_version = "10.3"
  backup_window = "10:00-10:30"
  maintenance_window = "Mon:18:00-Mon:18:30"
  password = "${var.contacts_db_password}"
  username = "root"
  db_security_group_ingress_cidr_blocks = "${join(",", data.terraform_remote_state.parent_account_sgs.twitch_subnets)}"
  db_subnet_ids = "subnet-cf9a03a8,subnet-b3b102fa,subnet-c83d2990"
  multi_az = true
  apply_immediately = true
}

# For now, put all the RDS in the same VPC for simplicity
#module "tf_aws_db_instance_canary" {
#  source = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_aws_db_instance.git?ref=3.1.3"
#  identifier = "qe-contacts-canary"
#  db_subnet_group_name = "qe-contacts-canary"
#  aws_profile = "${var.contacts_aws_profile}"
#  aws_region = "${var.contacts_aws_region}"
#  owner = "qe"
#  service = "contacts-service"
#  tag_service = "qe/contacts-service"
#  tag_owner = "lukemng@justin.tv"
#  environment = "canary"
#  vpc_id = "${data.terraform_remote_state.parent_account_vpc.vpc_id}"
#  engine = "mysql"
#  password = "${var.contacts_db_password}"
#  username = "root"
#  db_security_group_ingress_cidr_blocks = "${join(",", data.terraform_remote_state.parent_account_sgs.twitch_subnets)}"
#  db_subnet_ids = "subnet-cf9a03a8,subnet-b3b102fa,subnet-c83d2990"
#  multi_az = true
#  apply_immediately = true
#}

module "tf_aws_db_instance_production" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_aws_db_instance.git?ref=3.1.3"
  identifier = "qe-contacts-production"
  db_subnet_group_name = "qe-contacts-production"
  aws_profile = "${var.contacts_aws_profile}"
  aws_region = "${var.contacts_aws_region}"
  owner = "qe"
  service = "contacts-service"
  tag_service = "qe/contacts-service"
  tag_owner = "lukemng@justin.tv"
  environment = "production"
  vpc_id = "${data.terraform_remote_state.parent_account_vpc.vpc_id}"
  engine = "postgres"
  engine_version = "10.3"
  backup_window = "10:00-10:30"
  maintenance_window = "Mon:18:30-Mon:19:00"
  password = "${var.contacts_db_password}"
  username = "root"
  db_security_group_ingress_cidr_blocks = "${join(",", data.terraform_remote_state.parent_account_sgs.twitch_subnets)}"
  db_subnet_ids = "subnet-cf9a03a8,subnet-b3b102fa,subnet-c83d2990"
  multi_az = true
  apply_immediately = true
}