// Reference: https://github.com/datawire/tf-sns-pagerduty/blob/master/main.tf
resource "aws_sns_topic" "qe_contacts_service_service_pagerduty" {
  name = "qe-contacts-service-pagerduty"
  display_name = "qe-contacts-service-pagerduty"
}

resource "aws_sns_topic_subscription" "pagerduty" {
  // Reference: https://twitchoncall.pagerduty.com/services/PXG23TY/integrations/PX2NXE4
  endpoint = "https://events.pagerduty.com/integration/41ed1c55de624127af8c2e466e0a5b29/enqueue"
  endpoint_auto_confirms = true
  protocol = "https"
  topic_arn = "${aws_sns_topic.qe_contacts_service_service_pagerduty.arn}"
}
