// Common variables and data go in here

variable "contacts_aws_profile" {
  default = "twitch-cape-qe-aws"
}

variable "contacts_aws_region" {
  default = "us-west-2"
}

variable "qe_tf_state_bucket_name" {
  default = "tf-state-qe"
}

variable "environments" {
  description = "Environments"
  type = "list"
  default = ["staging", "canary", "production"]
}

// Reference: https://git-aws.internal.justin.tv/qe/terraform/blob/master/accounts/twitch-cape-qe/vpc/main.tf
// Used for gathering Internal CIDRs
data "terraform_remote_state" "parent_account_sgs" {
  backend = "s3"
  config {
    profile = "${var.contacts_aws_profile}"
    bucket = "${var.qe_tf_state_bucket_name}"
    key    = "tfstate/qe/terraform/security-groups"
    region = "${var.contacts_aws_region}"
  }
}

data "terraform_remote_state" "parent_account_vpc" {
  backend = "s3"
  config {
    profile = "${var.contacts_aws_profile}"
    bucket = "${var.qe_tf_state_bucket_name}"
    key    = "tfstate/qe/terraform/vpc"
    region = "${var.contacts_aws_region}"
  }
}

variable "principal" {
  default = "arn:aws:iam::425992774280:root"
}

variable "owner" {
  default = "qe-team"
}

variable "repo" {
  default = "qe/contacts-service"
}

variable "lambda_bucket" {
  default = "contacts-service"
}

variable "lambda_runtime" {
  default = "go1.x"
}