#!/bin/bash

# Script which will build and prepare the new application for the Terraform Module

set -e

echo "Building application"
GOOS=linux go build -o cw_es_shipper ./...

echo "Preparing for lambda module"
zip -r cw_es_shipper.zip cw_es_shipper
rm cw_es_shipper
mv -i cw_es_shipper.zip terraform/modules/lambda/
git add terraform/modules/lambda/cw_es_shipper.zip

printf "\n=== IMPORTANT ===\nArtifacts have been staged to your git tree. Type 'git status' to see\n\n"
