package main

import (
	"fmt"
	"os"
)

const (
	EnvElasticsearchendpoint = "ES_ENDPOINT"
	EnvAwsRegion             = "AWS_REGION"
	DefaultAwsRegion         = "us-west-2"
)

// Application Configuration
type Config struct {
	ElasticsearchEndpoint string
	Region string
}

// Creates an Application Configuration
func NewConfig() (*Config, error) {
	c := &Config{
		Region: getRegion(),
	}

	// ES Endpoint
	esEndpoint, err := getElasticSearchEndpoint()
	if err != nil { return c, err }
	c.ElasticsearchEndpoint = esEndpoint

	return c, nil
}

// Returns back the user defined ElasticSearch Endpoint. Returns an error if it's not provided
func getElasticSearchEndpoint() (string, error) {
	esEndpoint := os.Getenv(EnvElasticsearchendpoint)
	if len(esEndpoint) > 0 {
		return esEndpoint, nil
	} else {
		return "", fmt.Errorf("missing required environment variable: %s", EnvElasticsearchendpoint)
	}
}

// Returns back the user defined Region, or the default if not provided
func getRegion() string {
	region := os.Getenv(EnvAwsRegion)
	if len(region) <= 0 {
		return DefaultAwsRegion
	} else {
		return region
	}
}
